/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.metrics;

public class TLSStatsData {
    private final long connectionId;
    private final String hostName;
    private final long messagesEncrypted;
    private final long encryptionLatency;
    private final long messagesDecrypted;
    private final long decryptionLatency;

    public TLSStatsData(long connectionId, String hostName, long messagesEncrypted, long encryptionLatency, long messagesDecrypted, long decryptionLatency) {
        this.connectionId = connectionId;
        this.hostName = hostName;
        this.messagesEncrypted = messagesEncrypted;
        this.encryptionLatency = encryptionLatency;
        this.messagesDecrypted = messagesDecrypted;
        this.decryptionLatency = decryptionLatency;
    }

    @Deprecated
    public TLSStatsData(long connectionId, String hostName, long[] enc, long[] dec) {
        this.connectionId = connectionId;
        this.hostName = hostName;
        this.messagesEncrypted = enc[0];
        this.encryptionLatency = enc[1];
        this.messagesDecrypted = dec[0];
        this.decryptionLatency = dec[1];
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public String getRemoteHostName() {
        return this.hostName;
    }

    public long getMessagesEncrypted() {
        return this.messagesEncrypted;
    }

    public long getMessagesDecrypted() {
        return this.messagesDecrypted;
    }

    public long getAverageEncryptionLatency() {
        return this.encryptionLatency / Math.max(this.messagesEncrypted, 1L);
    }

    public long getAverageDecryptionLatency() {
        return this.decryptionLatency / Math.max(this.messagesDecrypted, 1L);
    }
}

