/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network.metrics;

import com.google_voltpatches.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;

class StatsDataExtractor<C, D> {
    private final List<C> collectors;

    StatsDataExtractor(List<C> collectors) {
        this.collectors = Objects.requireNonNull(collectors, "collectors are required");
    }

    StatsDataExtractor() {
        this.collectors = null;
    }

    protected List<D> getStats(boolean interval, BiFunction<C, Boolean, Future<List<D>>> collectAction) {
        return this.getStats(interval, this.collectors, collectAction);
    }

    protected <T> List<D> getStats(boolean shouldReturnDelta, ImmutableCollection<T> values, Function<T, List<? extends C>> extractor, BiFunction<C, Boolean, Future<List<D>>> collectAction) {
        return values.stream().map(extractor).map(c -> this.getStats(shouldReturnDelta, (List<? extends C>)c, collectAction)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    protected List<D> getStats(boolean interval, List<? extends C> collectors, BiFunction<C, Boolean, Future<List<D>>> collectAction) {
        Objects.requireNonNull(collectors, "collectors are required");
        if (collectors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Future<List<D>>> deferers = new ArrayList<Future<List<D>>>(collectors.size());
        for (C collector : collectors) {
            deferers.add(collectAction.apply(collector, interval));
        }
        ArrayList<D> result = new ArrayList<D>();
        for (Future future : deferers) {
            result.addAll(this.awaitForStatsData(future));
        }
        return result;
    }

    private List<D> awaitForStatsData(Future<List<D>> future) {
        try {
            return future.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out retrieving stats from network thread, probably harmless", e);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            throw new RuntimeException("Could not fetch stats from network thread.", e);
        }
    }
}

