/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NIOReadStream;

public abstract class VoltProtocolHandler
implements InputHandler {
    private static AtomicLong m_globalConnectionCounter = new AtomicLong(0L);
    private static final int badMessageDumpLimit = Integer.parseInt(System.getProperty("VOLTDB_BAD_MESSAGE_DUMP_LIMIT", "512"));
    private final long m_connectionId = m_globalConnectionCounter.incrementAndGet();
    private int m_nextLength;

    public static long getNextConnectionId() {
        return m_globalConnectionCounter.incrementAndGet();
    }

    @Override
    public ByteBuffer retrieveNextMessage(NIOReadStream inputStream) throws BadMessageLength {
        ByteBuffer result = null;
        if (this.m_nextLength == 0 && inputStream.dataAvailable() > 4) {
            this.m_nextLength = inputStream.getInt();
            this.checkMessageLength(inputStream);
        }
        if (this.m_nextLength > 0 && inputStream.dataAvailable() >= this.m_nextLength) {
            result = ByteBuffer.allocate(this.m_nextLength);
            inputStream.getBytes(result.array());
            this.m_nextLength = 0;
        }
        return result;
    }

    @Override
    public ByteBuffer retrieveNextMessage(CompositeByteBuf inputBB) throws BadMessageLength {
        ByteBuffer result = null;
        if (this.m_nextLength == 0 && inputBB.readableBytes() > 4) {
            this.m_nextLength = inputBB.readInt();
            this.checkMessageLength(inputBB);
        }
        if (this.m_nextLength > 0 && inputBB.readableBytes() >= this.m_nextLength) {
            result = ByteBuffer.allocate(this.m_nextLength);
            inputBB.readBytes(result);
            this.m_nextLength = 0;
        }
        return result;
    }

    private void checkMessageLength(NIOReadStream inputStream) throws BadMessageLength {
        if (this.m_nextLength <= 0 || this.m_nextLength > 0x3200000) {
            Supplier<byte[]> getBytes = () -> {
                int len = Math.min(inputStream.dataAvailable(), badMessageDumpLimit);
                byte[] buff = new byte[len];
                if (len > 0) {
                    inputStream.getBytes(buff);
                }
                return buff;
            };
            throw new BadMessageLength(this.badMessageReason(), this.m_nextLength, getBytes);
        }
    }

    private void checkMessageLength(CompositeByteBuf inputBB) throws BadMessageLength {
        if (this.m_nextLength <= 0 || this.m_nextLength > 0x3200000) {
            Supplier<byte[]> getBytes = () -> {
                int len = Math.min(inputBB.readableBytes(), badMessageDumpLimit);
                byte[] buff = new byte[len];
                if (len > 0) {
                    inputBB.readBytes(buff);
                }
                return buff;
            };
            throw new BadMessageLength(this.badMessageReason(), this.m_nextLength, getBytes);
        }
    }

    private String badMessageReason() {
        if (this.m_nextLength <= 0) {
            return "Next message length is " + this.m_nextLength + " which is less than the minimum length 1";
        }
        return "Next message length is " + this.m_nextLength + " which is greater than the hardcoded max of 52428800. Break up the work into smaller chunks (2 megabytes is reasonable) and send as multiple messages or stored procedure invocations";
    }

    public static String formatBadLengthDump(String caption, BadMessageLength ex) {
        byte[] buf = ex.badMessage();
        String firstLine = String.format("%s, length %d %s\n", caption, buf.length, buf.length < badMessageDumpLimit ? "" : "(truncated)");
        int bytesPerLine = 32;
        int sbCapacity = firstLine.length() + buf.length * 3 + buf.length / bytesPerLine + 1;
        StringBuffer sb = new StringBuffer(sbCapacity);
        sb.append(firstLine);
        for (int i = 0; i < buf.length; i += bytesPerLine) {
            for (int j = 0; j < bytesPerLine && i + j < buf.length; ++j) {
                sb.append(String.format(" %02x", buf[i + j]));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void started(Connection c) {
    }

    @Override
    public void starting(Connection c) {
    }

    @Override
    public void stopped(Connection c) {
    }

    @Override
    public void stopping(Connection c) {
    }

    @Override
    public long connectionId() {
        return this.m_connectionId;
    }

    @Override
    public int getNextMessageLength() {
        return this.m_nextLength;
    }

    class BadMessageLength
    extends IOException {
        private static final long serialVersionUID = 8547352379044459911L;
        private int badLength;
        private byte[] availBytes;
        private Supplier<byte[]> getBytes;

        public BadMessageLength(String string, int badLength, Supplier<byte[]> getBytes) {
            super(string);
            this.badLength = badLength;
            this.getBytes = getBytes;
        }

        int badLength() {
            return this.badLength;
        }

        byte[] badMessage() {
            if (this.availBytes == null) {
                this.availBytes = this.getBytes.get();
            }
            return this.availBytes;
        }
    }
}

