/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.ReverseDNSPolicy;
import org.voltcore.network.VoltNetwork;
import org.voltcore.network.metrics.IOStatsCollector;
import org.voltcore.network.metrics.IOStatsData;
import org.voltcore.network.metrics.IOStatsDataExtractor;
import org.voltcore.network.metrics.NetworkMetricsCollector;
import org.voltcore.network.metrics.TLSStatsCollector;
import org.voltcore.network.metrics.TLSStatsData;
import org.voltcore.network.metrics.TLSStatsDataExtractor;
import org.voltcore.network.util.TimeProvider;

public class VoltNetworkPool {
    private static final Logger m_logger = LoggerFactory.getLogger(VoltNetworkPool.class);
    private final VoltNetwork[] m_networks;
    private final AtomicLong m_nextNetwork = new AtomicLong();
    public final String m_poolName;
    private final IOStatsDataExtractor m_ioStatsDataExtractor;
    private final TLSStatsDataExtractor m_tlsStatsDataExtractor;

    @VisibleForTesting
    public VoltNetworkPool() {
        this(1, 1, "");
    }

    public VoltNetworkPool(int numThreads, int startThreadId, String poolName) {
        this(numThreads, startThreadId, poolName, () -> NetworkMetricsCollector.NOOP);
    }

    public VoltNetworkPool(int numThreads, int startThreadId, String poolName, NetworkMetricsCollector.NetworkMetricsCollectorFactory metricCollectorFactory) {
        this.m_poolName = poolName;
        if (numThreads < 1) {
            throw new IllegalArgumentException("Must specify a positive number of threads");
        }
        this.m_networks = new VoltNetwork[numThreads];
        for (int ii = 0; ii < numThreads; ++ii) {
            this.m_networks[ii] = new VoltNetwork(ii + startThreadId, poolName, metricCollectorFactory.createNew());
        }
        List<IOStatsCollector> collectors = Arrays.asList(this.m_networks);
        this.m_ioStatsDataExtractor = new IOStatsDataExtractor(collectors);
        this.m_tlsStatsDataExtractor = new TLSStatsDataExtractor((List<TLSStatsCollector>)collectors);
    }

    public void start() {
        for (VoltNetwork vn : this.m_networks) {
            vn.start();
        }
    }

    public void shutdown() throws InterruptedException {
        for (VoltNetwork vn : this.m_networks) {
            vn.shutdown();
        }
    }

    public Connection registerChannel(SocketChannel channel, InputHandler handler, CipherExecutor cipherService, SSLEngine sslEngine, TimeProvider timeProvider) throws IOException {
        return this.registerChannel(channel, handler, 1, ReverseDNSPolicy.ASYNCHRONOUS, cipherService, sslEngine, timeProvider);
    }

    public Connection registerChannel(SocketChannel channel, InputHandler handler, int interestOps, ReverseDNSPolicy dns, CipherExecutor cipherService, SSLEngine sslEngine, TimeProvider timeProvider) throws IOException {
        VoltNetwork vn = this.m_networks[(int)(this.m_nextNetwork.getAndIncrement() % (long)this.m_networks.length)];
        for (int ii = 0; ii < this.m_networks.length; ++ii) {
            if (this.m_networks[ii] == vn || vn.numPorts() <= this.m_networks[ii].numPorts()) continue;
            vn = this.m_networks[ii];
        }
        return vn.registerChannel(channel, handler, interestOps, dns, cipherService, sslEngine, timeProvider);
    }

    public List<Long> getThreadIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (VoltNetwork vn : this.m_networks) {
            ids.add(vn.getThreadId());
        }
        return ids;
    }

    public List<IOStatsData> getIOStats(boolean interval) {
        return this.m_ioStatsDataExtractor.getIOStats(interval);
    }

    public List<TLSStatsData> getTLSStats(boolean interval) {
        return this.m_tlsStatsDataExtractor.getTLSStats(interval);
    }

    /*
     * WARNING - void declaration
     */
    public Set<Connection> getConnections() {
        void var4_6;
        ArrayList<Future<Set<Connection>>> futures = new ArrayList<Future<Set<Connection>>>(this.m_networks.length);
        VoltNetwork[] voltNetworkArray = this.m_networks;
        int n = voltNetworkArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            VoltNetwork vn = voltNetworkArray[var4_6];
            futures.add(vn.getConnections());
            ++var4_6;
        }
        HashSet<Connection> conns = new HashSet<Connection>();
        for (Future future : futures) {
            HashSet connsForNetwork;
            try {
                connsForNetwork = (HashSet)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                connsForNetwork = new HashSet();
            }
            conns.addAll(connsForNetwork);
        }
        return conns;
    }
}

