/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NIOReadStream;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.TLSDecryptionAdapter;
import org.voltcore.network.VoltNIOWriteStream;
import org.voltcore.network.VoltNetwork;
import org.voltcore.network.VoltPort;
import org.voltcore.network.VoltTLSNIOWriteStream;
import org.voltcore.network.util.TimeProvider;

public class TLSVoltPort
extends VoltPort {
    private final TLSDecryptionAdapter m_tlsDecryptAdapter;
    private final SSLEngine m_sslEngine;
    private final CipherExecutor m_cipherExecutor;
    private final AtomicBoolean m_signal = new AtomicBoolean(false);

    public TLSVoltPort(VoltNetwork network, InputHandler handler, InetSocketAddress remoteAddress, NetworkDBBPool pool, SSLEngine sslEngine, CipherExecutor cipherExecutor, TimeProvider timeProvider) {
        super(network, handler, remoteAddress, pool, timeProvider);
        this.m_sslEngine = sslEngine;
        this.m_cipherExecutor = cipherExecutor;
        this.m_tlsDecryptAdapter = new TLSDecryptionAdapter(this, handler, sslEngine, cipherExecutor, this.m_networkCollector);
    }

    @Override
    protected void setKey(SelectionKey key) {
        this.m_selectionKey = key;
        this.m_channel = (SocketChannel)key.channel();
        this.m_readStream = new NIOReadStream();
        this.m_writeStream = new VoltTLSNIOWriteStream(this, this.m_handler.offBackPressure(), this.m_handler.onBackPressure(), this.m_handler.writestreamMonitor(), this.m_sslEngine, this.m_cipherExecutor, this.m_timeProvider, this.m_networkCollector);
        this.m_interestOps = key.interestOps();
    }

    @Override
    void die() {
        super.die();
        this.m_tlsDecryptAdapter.die();
        this.releaseSslEngine();
    }

    private void waitForPendingEncrypts() throws IOException {
        ((VoltTLSNIOWriteStream)this.m_writeStream).waitForPendingEncrypts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        try {
            do {
                try {
                    TLSDecryptionAdapter.ReadResult readInfo = this.m_tlsDecryptAdapter.handleInputStreamMessages(this.readyForRead(), this.readStream(), this.m_channel, this.m_pool);
                    this.m_messagesRead += (long)readInfo.getMessagesRead();
                    this.m_networkCollector.recordMessageRead(this.m_handler.connectionId(), readInfo.getMessagesRead(), this.readStream().dataAvailable(), readInfo.getReadBytes());
                }
                catch (EOFException e) {
                    this.m_networkCollector.recordReadError(this.m_handler.connectionId());
                    this.handleReadStreamEOF();
                }
                catch (Throwable e) {
                    this.m_networkCollector.recordReadError(this.m_handler.connectionId());
                    throw e;
                }
                if (this.m_network.isStopping() || this.m_isShuttingDown) {
                    this.m_tlsDecryptAdapter.waitForPendingDecrypts();
                }
                this.drainEncryptedStream();
            } while (this.m_signal.compareAndSet(true, false));
        }
        finally {
            Object object = this.m_lock;
            synchronized (object) {
                assert (this.m_running);
                this.m_running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainEncryptedStream() throws IOException {
        this.m_writeStream.serializeQueuedWrites(this.m_pool);
        if (this.m_network.isStopping()) {
            this.waitForPendingEncrypts();
        }
        VoltNIOWriteStream voltNIOWriteStream = this.m_writeStream;
        synchronized (voltNIOWriteStream) {
            if (!this.m_writeStream.isEmpty()) {
                this.m_writeStream.drainTo(this.m_channel);
                this.m_networkCollector.recordMessageWritten(this.m_handler.connectionId(), this.m_writeStream.m_bytesWritten, this.m_writeStream.m_messagesWritten, this.m_writeStream.getOutstandingMessageCount());
            }
            if (this.m_writeStream.isEmpty()) {
                this.disableWriteSelection();
                if (this.m_isShuttingDown) {
                    this.m_channel.close();
                    this.unregistered();
                }
            }
        }
    }

    @Override
    public void enableWriteSelection() {
        this.m_signal.set(true);
        super.enableWriteSelection();
    }

    @Override
    void unregistered() {
        try {
            this.m_tlsDecryptAdapter.waitForPendingDecrypts();
        }
        catch (IOException e) {
            networkLog.warn("unregistered port had an decryption task drain fault", (Throwable)e);
        }
        try {
            this.waitForPendingEncrypts();
        }
        catch (IOException e) {
            networkLog.warn("unregistered port had an encryption task drain fault", (Throwable)e);
        }
        this.m_tlsDecryptAdapter.releaseDecryptedBuffer();
        this.m_networkCollector.clean(this.m_handler.connectionId());
        super.unregistered();
        this.releaseSslEngine();
    }

    void releaseSslEngine() {
        if (this.m_sslEngine instanceof ReferenceCountedOpenSslEngine) {
            try {
                ReferenceCountedOpenSslEngine rcEng = (ReferenceCountedOpenSslEngine)this.m_sslEngine;
                if (rcEng.refCnt() > 0) {
                    rcEng.release();
                }
            }
            catch (Exception e) {
                networkLog.warn("unable to release SSL Engine", (Throwable)e);
            }
        }
    }

    @Override
    long[] getDecryptionStats(boolean delta) {
        return this.m_tlsDecryptAdapter.getDecryptionStats(delta);
    }
}

