/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.voltcore.memory.DBBPool;

public class NetworkDBBPool {
    private static final int LIMIT = Integer.getInteger("NETWORK_DBB_LIMIT", 512);
    private static final int SIZE = Integer.getInteger("NETWORK_DBB_SIZE", 32768);
    private final DBBPool.BBCachingContainer.CachingPredicate predicate;
    private final Queue<DBBPool.BBContainer> m_buffers;
    private final int m_allocationSize;

    public NetworkDBBPool(int numBuffers) {
        this(numBuffers, SIZE);
    }

    NetworkDBBPool(int numBuffers, int allocSize) {
        this.m_buffers = new ArrayBlockingQueue<DBBPool.BBContainer>(numBuffers);
        this.m_allocationSize = allocSize;
        this.predicate = container -> !this.m_buffers.offer(container);
    }

    public NetworkDBBPool() {
        this(LIMIT, SIZE);
    }

    DBBPool.BBContainer acquire() {
        DBBPool.BBContainer cont = this.m_buffers.poll();
        if (cont == null) {
            cont = DBBPool.allocateDirect(this.m_allocationSize);
        }
        cont.b().clear();
        return new DBBPool.BBCachingContainer(cont, this.predicate);
    }

    void clear() {
        DBBPool.BBContainer cont;
        while ((cont = this.m_buffers.poll()) != null) {
            cont.discard();
        }
    }
}

