/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.voltcore.memory.DBBPool;
import org.voltcore.network.NetworkDBBPool;

public class NIOReadStream {
    private final Deque<DBBPool.BBContainer> m_readBBContainers = new ArrayDeque<DBBPool.BBContainer>();
    private DBBPool.BBContainer m_poolBBContainer = null;
    protected int m_totalAvailable = 0;
    private long m_bytesRead = 0L;
    private long m_lastBytesRead = 0L;

    public int dataAvailable() {
        return this.m_totalAvailable;
    }

    int getInt() {
        byte[] intbytes = new byte[4];
        this.getBytes(intbytes);
        int output = 0;
        for (int i = 0; i < intbytes.length; ++i) {
            output <<= 8;
            output |= intbytes[i] & 0xFF;
        }
        return output;
    }

    void getBytes(byte[] output) {
        if (this.m_totalAvailable < output.length) {
            throw new IllegalStateException("Requested " + output.length + " bytes; only have " + this.m_totalAvailable + " bytes; call tryRead() first");
        }
        int bytesCopied = 0;
        while (bytesCopied < output.length) {
            DBBPool.BBContainer firstC = this.m_readBBContainers.peekFirst();
            if (firstC == null) {
                this.m_poolBBContainer.b().flip();
                this.m_readBBContainers.add(this.m_poolBBContainer);
                firstC = this.m_poolBBContainer;
                this.m_poolBBContainer = null;
            }
            ByteBuffer first = firstC.b();
            assert (first.remaining() > 0);
            int bytesToCopy = output.length - bytesCopied;
            int bytesRemaining = first.remaining();
            if (bytesToCopy > bytesRemaining) {
                bytesToCopy = bytesRemaining;
            }
            first.get(output, bytesCopied, bytesToCopy);
            bytesCopied += bytesToCopy;
            this.m_totalAvailable -= bytesToCopy;
            if (first.remaining() != 0) continue;
            this.m_readBBContainers.poll();
            firstC.discard();
        }
    }

    Slice getSlice(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("negative slice size: " + size);
        }
        if (this.m_totalAvailable < size) {
            throw new IllegalStateException("Requested " + size + " bytes; only have " + this.m_totalAvailable + " bytes; call tryRead() first");
        }
        ImmutableList.Builder slices = ImmutableList.builder();
        int bytesSliced = 0;
        while (bytesSliced < size) {
            DBBPool.BBContainer firstC = this.m_readBBContainers.peekFirst();
            if (firstC == null) {
                this.m_poolBBContainer.b().flip();
                this.m_readBBContainers.add(this.m_poolBBContainer);
                firstC = this.m_poolBBContainer;
                this.m_poolBBContainer = null;
            }
            ByteBuffer first = firstC.b();
            assert (first.remaining() > 0) : "no remaining bytes to read";
            int bytesToCopy = size - bytesSliced;
            int bytesRemaining = first.remaining();
            if (bytesToCopy > bytesRemaining) {
                bytesToCopy = bytesRemaining;
            }
            slices.add(new ContainerSlice(firstC, bytesToCopy));
            first.position(first.position() + bytesToCopy);
            bytesSliced += bytesToCopy;
            this.m_totalAvailable -= bytesToCopy;
            if (first.remaining() != 0) continue;
            this.m_readBBContainers.poll();
        }
        return new Slice((List<ContainerSlice>)((Object)slices.build()));
    }

    void peekBytes(byte[] output) {
        int bytesToCopy;
        if (this.m_totalAvailable < output.length) {
            throw new IllegalStateException("Requested " + output.length + " bytes; only have " + this.m_totalAvailable + " bytes; call tryRead() first");
        }
        Iterator<DBBPool.BBContainer> cntnritr = this.m_readBBContainers.iterator();
        for (int bytesPeeked = 0; bytesPeeked < output.length; bytesPeeked += bytesToCopy) {
            ByteBuffer slice;
            if (!cntnritr.hasNext()) {
                slice = this.m_poolBBContainer.b().duplicate();
                slice.flip();
            } else {
                slice = cntnritr.next().b().slice();
            }
            int bytesRemaining = slice.remaining();
            bytesToCopy = output.length - bytesPeeked;
            if (bytesToCopy > bytesRemaining) {
                bytesToCopy = bytesRemaining;
            }
            slice.get(output, bytesPeeked, bytesToCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(ReadableByteChannel channel, int maxBytes, NetworkDBBPool pool) throws IOException {
        int bytesRead = 0;
        int lastRead = 1;
        try {
            while (bytesRead < maxBytes && lastRead > 0) {
                ByteBuffer poolBuffer = null;
                if (this.m_poolBBContainer == null) {
                    this.m_poolBBContainer = pool.acquire();
                    poolBuffer = this.m_poolBBContainer.b();
                    poolBuffer.clear();
                } else {
                    poolBuffer = this.m_poolBBContainer.b();
                }
                lastRead = channel.read(poolBuffer);
                if (lastRead < 0 && bytesRead == 0) {
                    if (poolBuffer.position() == 0) {
                        this.m_poolBBContainer.discard();
                        this.m_poolBBContainer = null;
                    }
                    int n = -1;
                    return n;
                }
                if (lastRead > 0) {
                    bytesRead += lastRead;
                    if (!poolBuffer.hasRemaining()) {
                        poolBuffer.flip();
                        this.m_readBBContainers.add(this.m_poolBBContainer);
                        this.m_poolBBContainer = null;
                        continue;
                    }
                    break;
                }
                if (poolBuffer.position() != 0) continue;
                this.m_poolBBContainer.discard();
                this.m_poolBBContainer = null;
            }
        }
        finally {
            if (bytesRead > 0) {
                this.m_bytesRead += (long)bytesRead;
                this.m_totalAvailable += bytesRead;
            }
        }
        return bytesRead;
    }

    void shutdown() {
        for (DBBPool.BBContainer c : this.m_readBBContainers) {
            c.discard();
        }
        if (this.m_poolBBContainer != null) {
            this.m_poolBBContainer.discard();
        }
        this.m_readBBContainers.clear();
        this.m_poolBBContainer = null;
    }

    long getBytesRead(boolean collectDelta) {
        if (collectDelta) {
            long bytesRead = this.m_bytesRead;
            long bytesReadThisTime = bytesRead - this.m_lastBytesRead;
            this.m_lastBytesRead = bytesRead;
            return bytesReadThisTime;
        }
        return this.m_bytesRead;
    }

    private static final class ContainerSlice {
        private final DBBPool.BBContainer bbc;
        private final ByteBuffer bb;
        private final boolean discard;
        private final int size;

        private ContainerSlice(DBBPool.BBContainer bbc, int size) {
            this.discard = size == bbc.b().remaining();
            ByteBuffer slice = bbc.b().slice();
            slice.limit(size);
            this.bb = slice;
            this.bbc = bbc;
            this.size = size;
        }
    }

    public static final class Slice {
        private final List<ContainerSlice> m_slices;
        public final ByteBuf bb;
        private final BitSet m_discarded;

        private Slice(List<ContainerSlice> slices) {
            ByteBuffer[] bbs = new ByteBuffer[slices.size()];
            this.m_discarded = new BitSet(slices.size());
            for (int i = 0; i < slices.size(); ++i) {
                bbs[i] = slices.get((int)i).bb;
            }
            this.bb = Unpooled.wrappedBuffer((ByteBuffer[])bbs);
            this.m_slices = slices;
        }

        public Slice markConsumed() {
            if (this.bb.isReadable()) {
                this.bb.readerIndex(this.bb.writerIndex());
            }
            return this;
        }

        public int discard() {
            int discarded = 0;
            int size = 0;
            for (int i = 0; i < this.m_slices.size(); ++i) {
                ContainerSlice slc = this.m_slices.get(i);
                if (this.m_discarded.get(i) || !slc.discard || this.bb.readerIndex() < (size += slc.size)) continue;
                slc.bbc.discard();
                this.m_discarded.set(i);
                ++discarded;
            }
            return discarded;
        }
    }
}

