/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.util.concurrent.ListenableFuture;
import com.google_voltpatches.common.util.concurrent.ListeningExecutorService;
import com.google_voltpatches.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.util.CoreUtils;

public enum CipherExecutor {
    SERVER(CipherExecutor.getWishedThreadCount()),
    CLIENT(2);

    public static final int FRAME_SHIFT = 14;
    public static final int FRAME_SIZE = 16384;
    volatile ListeningExecutorService m_es;
    AtomicBoolean m_active = new AtomicBoolean(false);
    final int m_threadCount;
    private static final BigInteger LSB_MASK;

    private CipherExecutor(int nthreads) {
        this.m_threadCount = nthreads;
        this.m_es = CoreUtils.LISTENINGSAMETHREADEXECUTOR;
    }

    private static final int getWishedThreadCount() {
        Runtime rt = null;
        try {
            rt = Runtime.getRuntime();
        }
        catch (Throwable t) {
            rt = null;
        }
        int coreCount = rt != null ? rt.availableProcessors() : 2;
        return Math.max(2, coreCount / 2);
    }

    public final ListenableFuture<?> submit(Runnable r) {
        try {
            return this.m_es.submit(r);
        }
        catch (RejectedExecutionException e) {
            return CoreUtils.LISTENINGSAMETHREADEXECUTOR.submit(r);
        }
    }

    public final <T> ListenableFuture<T> submit(Callable<T> c) {
        try {
            return this.m_es.submit((Callable)c);
        }
        catch (RejectedExecutionException e) {
            return CoreUtils.LISTENINGSAMETHREADEXECUTOR.submit((Callable)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        if (this.m_active.compareAndSet(false, true)) {
            CipherExecutor cipherExecutor = this;
            synchronized (cipherExecutor) {
                ThreadFactory thrdfct = CoreUtils.getThreadFactory(this.name() + " SSL cipher service", 524288);
                this.m_es = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(this.m_threadCount, thrdfct));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.m_active.compareAndSet(true, false)) {
            CipherExecutor cipherExecutor = this;
            synchronized (cipherExecutor) {
                ListeningExecutorService es = this.m_es;
                if (es != CoreUtils.LISTENINGSAMETHREADEXECUTOR) {
                    this.m_es = CoreUtils.LISTENINGSAMETHREADEXECUTOR;
                    es.shutdown();
                    try {
                        es.awaitTermination(365L, TimeUnit.DAYS);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Interrupted while waiting for " + this.name() + " cipher service shutdown", e);
                    }
                }
            }
        }
    }

    public PooledByteBufAllocator allocator() {
        switch (this) {
            case CLIENT: {
                return ClientPoolHolder.INSTANCE;
            }
            case SERVER: {
                return ServerPoolHolder.INSTANCE;
            }
        }
        return null;
    }

    public static final int framesFor(int size) {
        int pages = size >> 14;
        int modulo = size & 0x3FFF;
        return modulo > 0 ? pages + 1 : pages;
    }

    public static CipherExecutor valueOf(SSLEngine engn) {
        return engn.getUseClientMode() ? CLIENT : SERVER;
    }

    public static final UUID digest(ByteBuf buf, int offset) {
        if (offset < 0) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("failed to get instantiate MD5 digester", e);
        }
        md.reset();
        ByteBuf bb = buf.slice();
        if (buf.readableBytes() <= offset) {
            return null;
        }
        bb.readerIndex(bb.readerIndex() + offset);
        while (bb.isReadable()) {
            md.update(bb.readByte());
        }
        BigInteger bi = new BigInteger(1, md.digest());
        return new UUID(bi.shiftRight(64).longValue(), bi.and(LSB_MASK).longValue());
    }

    public static final UUID digest(ByteBuffer buf, int offset) {
        if (offset < 0) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("failed to instantiate MD5 digester", e);
        }
        md.reset();
        ByteBuffer bb = null;
        bb = !buf.hasRemaining() && buf.limit() > 0 ? buf.duplicate().flip() : buf.slice();
        if (bb.remaining() <= offset) {
            return null;
        }
        bb.position(bb.position() + offset);
        while (bb.hasRemaining()) {
            md.update(bb.get());
        }
        BigInteger bi = new BigInteger(1, md.digest());
        return new UUID(bi.shiftRight(64).longValue(), bi.and(LSB_MASK).longValue());
    }

    static {
        LSB_MASK = new BigInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
    }

    private static class ClientPoolHolder {
        static final PooledByteBufAllocator INSTANCE = new PooledByteBufAllocator(true, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), 16384, PooledByteBufAllocator.defaultMaxOrder(), PooledByteBufAllocator.defaultTinyCacheSize(), PooledByteBufAllocator.defaultSmallCacheSize(), PooledByteBufAllocator.defaultNormalCacheSize(), PooledByteBufAllocator.defaultUseCacheForAllThreads());

        private ClientPoolHolder() {
        }
    }

    private static class ServerPoolHolder {
        static final PooledByteBufAllocator INSTANCE = new PooledByteBufAllocator(true, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), 16384, PooledByteBufAllocator.defaultMaxOrder(), PooledByteBufAllocator.defaultTinyCacheSize(), PooledByteBufAllocator.defaultSmallCacheSize(), 512, PooledByteBufAllocator.defaultUseCacheForAllThreads());

        private ServerPoolHolder() {
        }
    }
}

