/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.memory;

import java.util.ArrayList;
import java.util.List;
import org.voltcore.logging.VoltLogger;
import org.voltcore.memory.DBBPool;

class MemoryCheckExtension {
    private static final VoltLogger LOGGER = new VoltLogger("DBBPOOL");
    private final Throwable m_allocationThrowable = new Throwable("\"" + Thread.currentThread().getName() + "\" at " + System.currentTimeMillis());
    private volatile Throwable m_freeThrowable;
    private List<String> m_tags = null;

    MemoryCheckExtension() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDoubleFree() {
        MemoryCheckExtension memoryCheckExtension = this;
        synchronized (memoryCheckExtension) {
            if (this.m_freeThrowable != null) {
                System.err.println("Double free in DBBPool");
                System.err.println("Original free was by:");
                this.m_freeThrowable.printStackTrace();
                System.err.println("Current free was by:");
                Throwable t = new Throwable("\"" + Thread.currentThread().getName() + "\" at " + System.currentTimeMillis());
                t.printStackTrace();
                if (this.isTagged()) {
                    for (String tag : this.m_tags) {
                        System.err.println(tag);
                    }
                }
                LOGGER.fatal("Double free in DBBPool");
                LOGGER.fatal("Original free was by:", this.m_freeThrowable);
                LOGGER.fatal("Current free was by:", t);
                System.exit(-1);
            }
            this.m_freeThrowable = new Throwable("\"" + Thread.currentThread().getName() + "\" at " + System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tag(String tag) {
        MemoryCheckExtension memoryCheckExtension = this;
        synchronized (memoryCheckExtension) {
            if (this.m_tags == null) {
                this.m_tags = new ArrayList<String>();
            }
            String sb = "<<TAG:" + this.m_tags.size() + ">> " + tag + "\n" + DBBPool.throwableToString(new Throwable());
            this.m_tags.add(sb);
        }
    }

    public void addToTagTrail(String tag) {
        if (this.isTagged()) {
            this.tag(tag);
        }
    }

    public boolean isTagged() {
        return this.m_tags != null && !this.m_tags.isEmpty();
    }

    public void checkUseAfterFree() {
        if (this.m_freeThrowable != null) {
            System.err.println("Use after free in DBBPool");
            System.err.println("Free was by:");
            this.m_freeThrowable.printStackTrace();
            System.err.println("Use was by:");
            Throwable t = new Throwable("\"" + Thread.currentThread().getName() + "\" at " + System.currentTimeMillis());
            t.printStackTrace();
            if (this.isTagged()) {
                for (String tag : this.m_tags) {
                    System.err.println(tag);
                }
            }
            LOGGER.fatal("Use after free in DBBPool");
            LOGGER.fatal("Free was by:", this.m_freeThrowable);
            LOGGER.fatal("Use was by:", t);
            System.exit(-1);
        }
    }

    @Deprecated
    protected void finalize() {
        if (this.m_freeThrowable == null) {
            System.err.println("BBContainer " + Integer.toHexString(this.hashCode()) + " was never discarded allocated by:");
            this.m_allocationThrowable.printStackTrace();
            if (this.isTagged()) {
                for (String tag : this.m_tags) {
                    System.err.println(tag);
                }
            }
            LOGGER.fatal("BBContainer " + Integer.toHexString(this.hashCode()) + " was never discarded allocated by:", this.m_allocationThrowable);
            System.exit(-1);
        }
    }
}

