/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.memory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.voltcore.logging.VoltLogger;

public class MemcheckConfigurator {
    private static final VoltLogger LOGGER = new VoltLogger("DBBPOOL");
    static final String PATH = "/.memcheck.properties";
    static final String DISABLING_PROPERTY = "no_memcheck";
    static final String ENABLING_PROPERTY = "memcheck";
    private static final MemcheckConfigurator CONFIGURATOR = new MemcheckConfigurator();
    private final boolean enableMemoryCheck;

    public static boolean shouldCheckMemory() {
        return CONFIGURATOR.isMemoryCheckEnabled();
    }

    MemcheckConfigurator() {
        boolean result = false;
        try {
            Optional<Boolean> toggle = this.getRuntimeSystemProperty();
            result = toggle.orElseGet(() -> this.getConfiguredProperty().orElse(false));
        }
        catch (Throwable t) {
            LOGGER.debug("Could not read config, falling back to no_memcheck", t);
        }
        this.enableMemoryCheck = result;
    }

    public boolean isMemoryCheckEnabled() {
        return this.enableMemoryCheck;
    }

    private Optional<Boolean> getRuntimeSystemProperty() {
        String noMemcheck = this.getRuntimeProperty(DISABLING_PROPERTY);
        String memcheck = this.getRuntimeProperty(ENABLING_PROPERTY);
        return this.resolveMemCheckFlag(noMemcheck, memcheck);
    }

    private String getRuntimeProperty(String name) {
        String property = System.getProperty(name);
        if (property == null) {
            property = System.getProperty(name.toUpperCase());
        }
        return property;
    }

    private Optional<Boolean> getConfiguredProperty() {
        InputStream configuration = MemcheckConfigurator.class.getResourceAsStream(PATH);
        if (configuration != null) {
            try {
                Properties properties = new Properties();
                properties.load(configuration);
                return this.resolveMemCheckFlag(this.getProperty(properties, DISABLING_PROPERTY), this.getProperty(properties, ENABLING_PROPERTY));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private String getProperty(Properties properties, String name) {
        String property = properties.getProperty(name);
        if (property == null) {
            property = properties.getProperty(name.toUpperCase());
        }
        return property;
    }

    private Optional<Boolean> resolveMemCheckFlag(String noMemcheck, String memcheck) {
        LOGGER.debugFmt("Configuring memcheck with noMemcheck='%s' memcheck='%s'", noMemcheck, memcheck);
        Optional<Boolean> result = Optional.empty();
        if (!this.isNullOrEmpty(noMemcheck)) {
            result = Optional.of("false".equalsIgnoreCase(noMemcheck));
        } else if (!this.isNullOrEmpty(memcheck)) {
            result = Optional.of("true".equalsIgnoreCase(memcheck));
        }
        return result;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static {
        if (MemcheckConfigurator.shouldCheckMemory()) {
            System.setProperty("io.netty.leakDetection.level", "ADVANCED");
            LOGGER.warn("Strict java memory checking is enabled, don't do release builds or performance runs with this enabled. Invoke \"ant clean\" and \"ant -Djmemcheck=NO_MEMCHECK\" to disable.");
        }
    }
}

