/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.logging;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.voltcore.logging.Level;
import org.voltcore.logging.LogRateLimiter;
import org.voltcore.logging.VoltNullLogger;
import org.voltcore.logging.VoltUtilLoggingLogger;

public class VoltLogger {
    final CoreVoltLogger m_logger;
    private static final String ASYNCH_LOGGER_THREAD_NAME = "Async Logger";
    private static ExecutorService m_asynchLoggerPool;
    private static final LogRateLimiter m_rateLimiter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized void shutdownAsynchronousLogging() {
        if (m_asynchLoggerPool != null) {
            block5: {
                try {
                    m_asynchLoggerPool.submit(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }).get();
                }
                catch (Exception e) {
                    if (e.getCause() == null) break block5;
                    e.getCause().printStackTrace();
                }
            }
            m_asynchLoggerPool.shutdown();
            try {
                m_asynchLoggerPool.awaitTermination(365L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to shutdown database server logger", e);
            }
            m_asynchLoggerPool = null;
        }
    }

    public static synchronized void startAsynchronousLogging() {
        if ("true".equals(System.getProperty("voltdb_no_logging"))) {
            return;
        }
        if (m_asynchLoggerPool == null && !Boolean.getBoolean("DISABLE_ASYNC_LOGGING")) {
            m_asynchLoggerPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new LoggerThreadFactory());
            try {
                m_asynchLoggerPool.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unable to prime asynchronous logging", e);
            }
        }
    }

    private void submit(Level level, Object message, Object[] args, Throwable t) {
        if (!this.m_logger.isEnabledFor(level)) {
            return;
        }
        if (args != null) {
            message = this.formatString(message, args);
        }
        if (m_asynchLoggerPool == null) {
            this.m_logger.log(level, message, t);
            return;
        }
        Runnable task = this.createRunnableLoggingTask(level, message, t);
        try {
            m_asynchLoggerPool.submit(task).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void execute(Level level, Object message, Object[] args, Throwable t) {
        if (!this.m_logger.isEnabledFor(level)) {
            return;
        }
        if (args != null) {
            message = this.formatString(message, args);
        }
        if (m_asynchLoggerPool == null) {
            this.m_logger.log(level, message, t);
            return;
        }
        Runnable task = this.createRunnableLoggingTask(level, message, t);
        try {
            m_asynchLoggerPool.execute(task);
        }
        catch (RejectedExecutionException e) {
            this.m_logger.log(Level.DEBUG, "Failed to execute logging task. Running in-line", e);
            task.run();
        }
    }

    private String formatString(Object format, Object[] args) {
        try {
            return String.format(format.toString(), args);
        }
        catch (Exception ex1) {
            try {
                String err = String.format("Error formatting log message '%s' with arguments '%s'", format, Arrays.toString(args));
                this.m_logger.log(Level.ERROR, err, ex1);
                return format.toString();
            }
            catch (Exception ex2) {
                try {
                    String err = String.format("Error formatting log message '%s'", format);
                    this.m_logger.log(Level.ERROR, err, ex2);
                    return format.toString();
                }
                catch (Exception exception) {
                    return "Irrecoverable error formatting log message";
                }
            }
        }
    }

    private Runnable createRunnableLoggingTask(final Level level, final Object message, final Throwable t) {
        final String callerThreadName = Thread.currentThread().getName();
        return new Runnable(){

            @Override
            public void run() {
                Thread loggerThread = Thread.currentThread();
                loggerThread.setName(callerThreadName);
                try {
                    VoltLogger.this.m_logger.log(level, message, t);
                }
                catch (Throwable t2) {
                    System.err.printf("Exception thrown in logging thread for '%s': %s%n", callerThreadName, t2);
                }
                finally {
                    loggerThread.setName(VoltLogger.ASYNCH_LOGGER_THREAD_NAME);
                }
            }
        };
    }

    public void fatal(Object message) {
        this.submit(Level.FATAL, message, null, null);
    }

    public void fatalFmt(String format, Object ... args) {
        this.submit(Level.ERROR, format, args, null);
    }

    public void fatal(Object message, Throwable t) {
        this.submit(Level.FATAL, message, null, t);
    }

    public void fatalFmt(Throwable t, String format, Object ... args) {
        this.submit(Level.ERROR, format, args, t);
    }

    public void error(Object message) {
        this.submit(Level.ERROR, message, null, null);
    }

    public void errorFmt(String format, Object ... args) {
        this.submit(Level.ERROR, format, args, null);
    }

    public void error(Object message, Throwable t) {
        this.submit(Level.ERROR, message, null, t);
    }

    public void errorFmt(Throwable t, String format, Object ... args) {
        this.submit(Level.ERROR, format, args, t);
    }

    public void warn(Object message) {
        this.execute(Level.WARN, message, null, null);
    }

    public void warnFmt(String format, Object ... args) {
        this.execute(Level.WARN, format, args, null);
    }

    public void warn(Object message, Throwable t) {
        this.execute(Level.WARN, message, null, t);
    }

    public void warnFmt(Throwable t, String format, Object ... args) {
        this.execute(Level.WARN, format, args, t);
    }

    public void info(Object message) {
        this.execute(Level.INFO, message, null, null);
    }

    public void infoFmt(String format, Object ... args) {
        this.execute(Level.INFO, format, args, null);
    }

    public void info(Object message, Throwable t) {
        this.execute(Level.INFO, message, null, t);
    }

    public void infoFmt(Throwable t, String format, Object ... args) {
        this.execute(Level.INFO, format, args, t);
    }

    public void debug(Object message) {
        this.execute(Level.DEBUG, message, null, null);
    }

    public void debugFmt(String format, Object ... args) {
        this.execute(Level.DEBUG, format, args, null);
    }

    public void debug(Object message, Throwable t) {
        this.execute(Level.DEBUG, message, null, t);
    }

    public void debugFmt(Throwable t, String format, Object ... args) {
        this.execute(Level.DEBUG, format, args, t);
    }

    public void trace(Object message) {
        this.execute(Level.TRACE, message, null, null);
    }

    public void traceFmt(String format, Object ... args) {
        this.execute(Level.TRACE, format, args, null);
    }

    public void trace(Object message, Throwable t) {
        this.execute(Level.TRACE, message, null, t);
    }

    public void traceFmt(Throwable t, String format, Object ... args) {
        this.execute(Level.TRACE, format, args, t);
    }

    public void log(Level level, Object message, Throwable t) {
        this.logFmt(level, t, message, (Object[])null);
    }

    public void logFmt(Level level, String format, Object ... args) {
        this.logFmt(level, (Throwable)null, (Object)format, args);
    }

    public void logFmt(Level level, Throwable t, Object message, Object ... args) {
        switch (level) {
            case WARN: 
            case INFO: 
            case DEBUG: 
            case TRACE: {
                this.execute(level, message, args, t);
                break;
            }
            case FATAL: 
            case ERROR: {
                this.submit(level, message, args, t);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized level " + level));
            }
        }
    }

    public void rateLimitedLog(long suppressInterval, Level level, Throwable cause, String format, Object ... args) {
        if (m_rateLimiter.shouldLog(format, suppressInterval * 1000L)) {
            this.logFmt(level, cause, (Object)format, args);
        }
    }

    public void rateLimitedError(long suppressInterval, String format, Object ... args) {
        this.rateLimitedLog(suppressInterval, Level.ERROR, null, format, args);
    }

    public void rateLimitedWarn(long suppressInterval, String format, Object ... args) {
        this.rateLimitedLog(suppressInterval, Level.WARN, null, format, args);
    }

    public void rateLimitedInfo(long suppressInterval, String format, Object ... args) {
        this.rateLimitedLog(suppressInterval, Level.INFO, null, format, args);
    }

    public boolean isInfoEnabled() {
        return this.m_logger.isEnabledFor(Level.INFO);
    }

    public boolean isDebugEnabled() {
        return this.m_logger.isEnabledFor(Level.DEBUG);
    }

    public boolean isTraceEnabled() {
        return this.m_logger.isEnabledFor(Level.TRACE);
    }

    public boolean isEnabledFor(Level level) {
        return this.m_logger.isEnabledFor(level);
    }

    public long getLogLevels(VoltLogger[] loggers) {
        return this.m_logger.getLogLevels(loggers);
    }

    public void setLevel(Level level) {
        this.m_logger.setLevel(level);
    }

    public VoltLogger(String classname) {
        if ("true".equals(System.getProperty("voltdb_no_logging"))) {
            this.m_logger = new VoltNullLogger.CoreNullLogger();
            return;
        }
        CoreVoltLogger tempLogger = null;
        try {
            Class<?> loggerClz = Class.forName("org.voltcore.logging.VoltLog4jLogger");
            if (!$assertionsDisabled && loggerClz == null) {
                throw new AssertionError();
            }
            Constructor<?> constructor = loggerClz.getConstructor(String.class);
            tempLogger = (CoreVoltLogger)constructor.newInstance(classname);
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (tempLogger == null) {
            tempLogger = new VoltUtilLoggingLogger(classname);
        }
        this.m_logger = tempLogger;
    }

    protected VoltLogger(CoreVoltLogger logger) {
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        this.m_logger = logger;
    }

    public static void logWithEmphasis(VoltLogger vLogger, String msg, Level level) {
        if (vLogger == null || msg == null || level == Level.OFF) {
            return;
        }
        int width = msg.length() + 4;
        StringBuilder starBuilder = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            starBuilder.append('*');
        }
        String stars = starBuilder.toString();
        String xmsg = "* " + msg + " *";
        vLogger.log(level, stars, null);
        vLogger.log(level, xmsg, null);
        vLogger.log(level, stars, null);
    }

    static {
        boolean bl = $assertionsDisabled = !VoltLogger.class.desiredAssertionStatus();
        m_asynchLoggerPool = Boolean.getBoolean("DISABLE_ASYNC_LOGGING") ? null : ("true".equals(System.getProperty("voltdb_no_logging")) ? null : new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new LoggerThreadFactory()));
        m_rateLimiter = new LogRateLimiter();
    }

    private static class LoggerThreadFactory
    implements ThreadFactory {
        private static final int SMALL_STACK_SIZE = 262144;

        private LoggerThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            Thread t = new Thread(null, runnable, VoltLogger.ASYNCH_LOGGER_THREAD_NAME, 262144L);
            t.setDaemon(true);
            return t;
        }
    }

    static interface CoreVoltLogger {
        public boolean isEnabledFor(Level var1);

        public void log(Level var1, Object var2, Throwable var3);

        public long getLogLevels(VoltLogger[] var1);

        public void setLevel(Level var1);
    }
}

