/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.voltcore.utils.EstTime;

class LogRateLimiter {
    static final int MAXSIZE = 1000;
    private final ConcurrentHashMap<String, Timestamp> whenLogged = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<String> ageOrder = new ConcurrentLinkedQueue();

    LogRateLimiter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldLog(String str, long interval) {
        boolean decision;
        block8: {
            decision = false;
            try {
                long now = EstTime.currentTimeMillis();
                Timestamp ts = this.whenLogged.computeIfAbsent(str, k -> new Timestamp());
                if (now - ts.value <= interval) break block8;
                boolean newTs = false;
                Timestamp timestamp = ts;
                synchronized (timestamp) {
                    if (now - ts.value > interval) {
                        boolean bl = newTs = ts.value == 0L;
                        if (newTs || this.ageOrder.remove(str)) {
                            this.ageOrder.add(str);
                        }
                        ts.value = now;
                        decision = true;
                    }
                }
                if (newTs) {
                    this.shrinkToLimit();
                }
            }
            catch (Exception ex) {
                decision = true;
            }
        }
        return decision;
    }

    private void shrinkToLimit() {
        String key;
        while (this.whenLogged.size() > 1000 && (key = this.ageOrder.poll()) != null) {
            this.whenLogged.remove(key);
        }
    }

    private static final class Timestamp {
        volatile long value;

        private Timestamp() {
        }
    }
}

