/*
 * Decompiled with CFR 0.152.
 */
package org.json_voltpatches;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONObject;
import org.json_voltpatches.JSONString;

public class JSONWriter {
    private static final int MAX_DEPTH = 20;
    private boolean m_expectingComma;
    private char m_mode;
    private final HashSet<String>[] m_scopeStack = new HashSetOfString[20];
    private int m_top;
    private final Writer m_writer;

    public JSONWriter(Writer writer) {
        this.m_writer = writer;
        this.m_top = -1;
        this.m_mode = (char)105;
        this.m_expectingComma = false;
    }

    protected Writer getWriter() {
        return this.m_writer;
    }

    protected boolean isDone() {
        return this.m_mode == 'd';
    }

    private void appendValue(String string) throws JSONException {
        assert (string != null);
        if (this.m_mode == 'k' || this.m_mode == 'i' || this.m_mode == 'd') {
            throw new JSONException("Value out of sequence.");
        }
        try {
            if (this.m_mode == 'a') {
                if (this.m_expectingComma) {
                    this.m_writer.write(44);
                }
            } else if (this.m_mode == 'o') {
                this.m_mode = (char)107;
            }
            this.m_writer.write(string);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_expectingComma = true;
    }

    private void push(ScopeOptions options) throws JSONException {
        HashSetOfString keyTracker;
        ++this.m_top;
        if (this.m_top >= 20) {
            throw new JSONException("Nesting too deep.");
        }
        try {
            this.m_writer.write(options.m_prefix);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_scopeStack[this.m_top] = keyTracker = options.createKeyTracker();
        this.m_mode = (char)(keyTracker == null ? 97 : 107);
        this.m_expectingComma = false;
    }

    private void pop(char closer) throws JSONException {
        if (this.m_top <= -1) {
            throw new JSONException("Nesting error.");
        }
        try {
            this.m_writer.write(closer);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        --this.m_top;
        this.m_mode = (char)(this.m_top == -1 ? 100 : (this.m_scopeStack[this.m_top] == null ? 97 : 107));
        this.m_expectingComma = true;
    }

    public JSONWriter array() throws JSONException {
        if (this.m_mode == 'k' || this.m_mode == 'd') {
            throw new JSONException("Misplaced array.");
        }
        this.push(this.m_expectingComma ? ScopeOptions.ArrayWithComma : ScopeOptions.ArrayWithoutComma);
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        if (this.m_mode != 'a') {
            throw new JSONException("Misplaced endArray.");
        }
        this.pop(']');
        return this;
    }

    public JSONWriter object() throws JSONException {
        if (this.m_mode == 'k' || this.m_mode == 'd') {
            throw new JSONException("Misplaced object.");
        }
        this.push(this.m_expectingComma ? ScopeOptions.ObjectWithComma : ScopeOptions.ObjectWithoutComma);
        return this;
    }

    public JSONWriter endObject() throws JSONException {
        if (this.m_mode != 'k') {
            throw new JSONException("Misplaced endObject.");
        }
        this.pop('}');
        return this;
    }

    public JSONWriter key(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (this.m_mode != 'k') {
            throw new JSONException("Misplaced key.");
        }
        if (!this.m_scopeStack[this.m_top].add(string)) {
            throw new JSONException("Duplicate key \"" + string + "\"");
        }
        try {
            if (this.m_expectingComma) {
                this.m_writer.write(44);
            }
            this.m_writer.write(JSONObject.quote(string));
            this.m_writer.write(58);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_mode = (char)111;
        this.m_expectingComma = false;
        return this;
    }

    public JSONWriter value(boolean aValue) throws JSONException {
        this.appendValue(aValue ? "true" : "false");
        return this;
    }

    public JSONWriter value(double aValue) throws JSONException {
        this.appendValue(JSONObject.numberToString(aValue));
        return this;
    }

    public JSONWriter value(long aValue) throws JSONException {
        this.appendValue(Long.toString(aValue));
        return this;
    }

    public JSONWriter value(Object aValue) throws JSONException {
        this.appendValue(JSONObject.valueToString(aValue));
        return this;
    }

    public JSONWriter value(JSONString jss) throws JSONException {
        if (jss == null) {
            this.valueNull();
            return this;
        }
        try {
            String asString = jss.toJSONString();
            if (asString == null) {
                throw new JSONException("Unexpected null from toJSONString");
            }
            this.appendValue(asString);
            return this;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    public JSONWriter valueNull() throws JSONException {
        this.appendValue("null");
        return this;
    }

    public JSONWriter array(Iterable<? extends JSONString> iter) throws JSONException {
        this.array();
        for (JSONString jSONString : iter) {
            this.value(jSONString);
        }
        this.endArray();
        return this;
    }

    public JSONWriter keySymbolValuePair(String aKey, String aValue) throws JSONException {
        assert (aKey != null);
        assert (this.m_mode == 'k');
        assert (this.m_scopeStack[this.m_top].add(aKey));
        try {
            this.m_writer.write(this.m_expectingComma ? ",\"" : "\"");
            this.m_writer.write(aKey);
            if (aValue == null) {
                this.m_writer.write("\":null");
            } else {
                this.m_writer.write("\":\"");
                this.m_writer.write(JSONObject.quotable(aValue));
                this.m_writer.write(34);
            }
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_expectingComma = true;
        return this;
    }

    public JSONWriter keySymbolValuePair(String aKey, long aValue) throws JSONException {
        assert (aKey != null);
        assert (this.m_mode == 'k');
        assert (this.m_scopeStack[this.m_top].add(aKey));
        try {
            this.m_writer.write(this.m_expectingComma ? ",\"" : "\"");
            this.m_writer.write(aKey);
            this.m_writer.write("\":");
            this.m_writer.write(Long.toString(aValue));
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_expectingComma = true;
        return this;
    }

    public JSONWriter keySymbolValuePair(String aKey, boolean aValue) throws JSONException {
        assert (aKey != null);
        assert (this.m_mode == 'k');
        assert (this.m_scopeStack[this.m_top].add(aKey));
        try {
            this.m_writer.write(this.m_expectingComma ? ",\"" : "\"");
            this.m_writer.write(aKey);
            this.m_writer.write(aValue ? "\":true" : "\":false");
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_expectingComma = true;
        return this;
    }

    private static class HashSetOfString
    extends HashSet<String> {
        private static final long serialVersionUID = 1L;

        private HashSetOfString() {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ScopeOptions {
        ArrayWithComma(",["){

            @Override
            HashSetOfString createKeyTracker() {
                return null;
            }
        }
        ,
        ArrayWithoutComma("["){

            @Override
            HashSetOfString createKeyTracker() {
                return null;
            }
        }
        ,
        ObjectWithComma(",{"),
        ObjectWithoutComma("{");

        final String m_prefix;

        private ScopeOptions(String prefix) {
            this.m_prefix = prefix;
        }

        HashSetOfString createKeyTracker() {
            return new HashSetOfString();
        }
    }
}

