/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute_voltpatches.compiler;

public abstract class JType {
    private String mCName;
    private String mCppName;
    private String mJavaName;
    private String mMethodSuffix;
    private String mWrapper;
    private String mUnwrapMethod;

    JType(String cname, String cppname, String javaname, String suffix, String wrapper, String unwrap) {
        this.mCName = cname;
        this.mCppName = cppname;
        this.mJavaName = javaname;
        this.mMethodSuffix = suffix;
        this.mWrapper = wrapper;
        this.mUnwrapMethod = unwrap;
    }

    abstract String getSignature();

    String genCppDecl(String fname) {
        return "  " + this.mCppName + " m" + fname + ";\n";
    }

    String genCDecl(String name) {
        return "    " + this.mCName + " " + name + ";\n";
    }

    String genJavaDecl(String fname) {
        return "  private " + this.mJavaName + " " + fname + ";\n";
    }

    String genJavaConstructorParam(String fname) {
        return "        " + this.mJavaName + " " + fname;
    }

    String genCppGetSet(String fname, int fIdx) {
        String getFunc = "  virtual " + this.mCppName + " get" + fname + "() const {\n";
        getFunc = getFunc + "    return m" + fname + ";\n";
        getFunc = getFunc + "  }\n";
        String setFunc = "  virtual void set" + fname + "(" + this.mCppName + " m_) {\n";
        setFunc = setFunc + "    m" + fname + "=m_; bs_.set(" + fIdx + ");\n";
        setFunc = setFunc + "  }\n";
        return getFunc + setFunc;
    }

    static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    String genJavaGetSet(String fname, int fIdx) {
        String getFunc = "  public " + this.mJavaName + " get" + JType.capitalize(fname) + "() {\n";
        getFunc = getFunc + "    return " + fname + ";\n";
        getFunc = getFunc + "  }\n";
        String setFunc = "  public void set" + JType.capitalize(fname) + "(" + this.mJavaName + " m_) {\n";
        setFunc = setFunc + "    " + fname + "=m_;\n";
        setFunc = setFunc + "  }\n";
        return getFunc + setFunc;
    }

    String getCType() {
        return this.mCName;
    }

    String getCppType() {
        return this.mCppName;
    }

    String getJavaType() {
        return this.mJavaName;
    }

    String getJavaWrapperType() {
        return this.mWrapper;
    }

    String getMethodSuffix() {
        return this.mMethodSuffix;
    }

    String genJavaWriteMethod(String fname, String tag) {
        return "    a_.write" + this.mMethodSuffix + "(" + fname + ",\"" + tag + "\");\n";
    }

    String genJavaReadMethod(String fname, String tag) {
        return "    " + fname + "=a_.read" + this.mMethodSuffix + "(\"" + tag + "\");\n";
    }

    String genJavaReadWrapper(String fname, String tag, boolean decl) {
        Object ret = "";
        if (decl) {
            ret = "    " + this.mWrapper + " " + fname + ";\n";
        }
        return (String)ret + "    " + fname + "=new " + this.mWrapper + "(a_.read" + this.mMethodSuffix + "(\"" + tag + "\"));\n";
    }

    String genJavaWriteWrapper(String fname, String tag) {
        return "        a_.write" + this.mMethodSuffix + "(" + fname + "." + this.mUnwrapMethod + "(),\"" + tag + "\");\n";
    }

    String genJavaCompareTo(String fname) {
        return "    ret = (" + fname + " == peer." + fname + ")? 0 :((" + fname + "<peer." + fname + ")?-1:1);\n";
    }

    String genJavaEquals(String fname, String peer) {
        return "    ret = (" + fname + "==" + peer + ");\n";
    }

    String genJavaHashCode(String fname) {
        return "    ret = (int)" + fname + ";\n";
    }

    String genJavaConstructorSet(String fname, String name) {
        return "    this." + fname + "=" + name + ";\n";
    }
}

