/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram_voltpatches;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import org.HdrHistogram_voltpatches.AbstractHistogram;
import org.HdrHistogram_voltpatches.Histogram;
import org.HdrHistogram_voltpatches.HistogramIterationValue;
import org.HdrHistogram_voltpatches.PercentileIterator;
import org.voltcore.utils.CompressionStrategy;

public class HdrHistogramHelper {
    public static void reestablishTotalCount(AbstractHistogram histogram) {
        long totalCounted = 0L;
        for (int i = 0; i < histogram.countsArrayLength; ++i) {
            totalCounted += histogram.getCountAtIndex(i);
        }
        histogram.setTotalCount(totalCounted);
    }

    public static boolean hasOverflowed(AbstractHistogram histogram) {
        long totalCounted = 0L;
        for (int i = 0; i < histogram.countsArrayLength; ++i) {
            totalCounted += histogram.getCountAtIndex(i);
        }
        return totalCounted != histogram.getTotalCount();
    }

    public static Histogram diff(Histogram newer, Histogram older) {
        Histogram h = new Histogram(newer.getLowestDiscernibleValue(), newer.getHighestTrackableValue(), newer.getNumberOfSignificantValueDigits());
        h.totalCount = newer.totalCount - older.totalCount;
        for (int ii = 0; ii < h.countsArrayLength; ++ii) {
            h.counts[ii] = newer.counts[ii] - older.counts[ii];
        }
        HdrHistogramHelper.reestablishTotalCount(h);
        return h;
    }

    public static void outputPercentileDistributionVolt(AbstractHistogram histogram, PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio) {
        HdrHistogramHelper.outputPercentileDistributionVolt(histogram, printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio, false);
    }

    public static void outputPercentileDistributionVolt(AbstractHistogram histogram, PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio, boolean useCsvFormat) {
        String lastLinePercentileFormatString;
        String percentileFormatString;
        if (useCsvFormat) {
            printStream.format("\"Value\",\"Percentile\",\"TotalCount\"\n", new Object[0]);
        } else {
            printStream.format("%12s %14s %10s\n\n", "Value", "Percentile", "TotalCount");
        }
        PercentileIterator iterator = histogram.percentileIterator;
        iterator.reset(percentileTicksPerHalfDistance);
        if (useCsvFormat) {
            percentileFormatString = "%." + histogram.numberOfSignificantValueDigits + "f,%.12f,%d\n";
            lastLinePercentileFormatString = "%." + histogram.numberOfSignificantValueDigits + "f,%.12f,%d\n";
        } else {
            percentileFormatString = "%12." + histogram.numberOfSignificantValueDigits + "f %2.12f %10d\n";
            lastLinePercentileFormatString = "%12." + histogram.numberOfSignificantValueDigits + "f %2.12f\n";
        }
        try {
            while (iterator.hasNext()) {
                HistogramIterationValue iterationValue = iterator.next();
                if (iterationValue.getPercentileLevelIteratedTo() != 100.0) {
                    printStream.format(Locale.US, percentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getCountAddedInThisIterationStep());
                    continue;
                }
                printStream.format(Locale.US, lastLinePercentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getCountAddedInThisIterationStep());
            }
            if (!useCsvFormat) {
                double mean = histogram.getMean() / outputValueUnitScalingRatio;
                double std_deviation = histogram.getStdDeviation() / outputValueUnitScalingRatio;
                printStream.format(Locale.US, "#[Mean    = %12." + histogram.numberOfSignificantValueDigits + "f, StdDeviation   = %12." + histogram.numberOfSignificantValueDigits + "f]\n", mean, std_deviation);
                printStream.format(Locale.US, "#[Max     = %12." + histogram.numberOfSignificantValueDigits + "f, Total count    = %12d]\n", (double)histogram.getMaxValue() / outputValueUnitScalingRatio, histogram.getTotalCount());
                printStream.format(Locale.US, "#[Buckets = %12d, SubBuckets     = %12d]\n", histogram.bucketCount, histogram.subBucketCount);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (HdrHistogramHelper.hasOverflowed(histogram)) {
                printStream.format(Locale.US, "# Histogram counts indicate OVERFLOW values", new Object[0]);
            }
            throw e;
        }
    }

    public static byte[] toUncompressedBytes(AbstractHistogram abstractHistogram) {
        ByteBuffer buf = ByteBuffer.allocate(8 * abstractHistogram.countsArrayLength + 24 + 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(abstractHistogram.lowestDiscernibleValue);
        buf.putLong(abstractHistogram.highestTrackableValue);
        buf.putInt(abstractHistogram.numberOfSignificantValueDigits);
        buf.putLong(abstractHistogram.getTotalCount());
        for (int ii = 0; ii < abstractHistogram.countsArrayLength; ++ii) {
            buf.putLong(abstractHistogram.getCountAtIndex(ii));
        }
        return buf.array();
    }

    public static byte[] toCompressedBytes(byte[] bytes, CompressionStrategy strategy) {
        try {
            return strategy.compress(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Histogram fromCompressedBytes(byte[] bytes, CompressionStrategy strategy) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(strategy.uncompress(bytes));
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long lTrackableValue = buf.getLong();
            long hTrackableValue = buf.getLong();
            int nSVD = buf.getInt();
            Histogram h = new Histogram(lTrackableValue, hTrackableValue, nSVD);
            h.addToTotalCount(buf.getLong());
            for (int ii = 0; ii < h.countsArrayLength; ++ii) {
                h.addToCountAtIndex(ii, buf.getLong());
            }
            return h;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

