/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.custom;

import com.virtuslab.using_directives.custom.model.BooleanValue;
import com.virtuslab.using_directives.custom.model.EmptyValue;
import com.virtuslab.using_directives.custom.model.Path;
import com.virtuslab.using_directives.custom.model.StringValue;
import com.virtuslab.using_directives.custom.model.UsingDirectives;
import com.virtuslab.using_directives.custom.model.UsingDirectivesImpl;
import com.virtuslab.using_directives.custom.model.Value;
import com.virtuslab.using_directives.custom.utils.KeyValue;
import com.virtuslab.using_directives.custom.utils.ast.BooleanLiteral;
import com.virtuslab.using_directives.custom.utils.ast.StringLiteral;
import com.virtuslab.using_directives.custom.utils.ast.UsingDef;
import com.virtuslab.using_directives.custom.utils.ast.UsingDefs;
import com.virtuslab.using_directives.custom.utils.ast.UsingPrimitive;
import com.virtuslab.using_directives.custom.utils.ast.UsingTree;
import com.virtuslab.using_directives.custom.utils.ast.UsingValue;
import com.virtuslab.using_directives.custom.utils.ast.UsingValues;
import com.virtuslab.using_directives.reporter.Reporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Visitor {
    private final UsingTree root;
    private final Reporter reporter;

    public Visitor(UsingTree root, Reporter reporter) {
        this.reporter = reporter;
        this.root = root;
    }

    public UsingTree getRoot() {
        return this.root;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public UsingDirectives visit() {
        Map<Path, List<Value<?>>> flattenView = this.getFlatView(this.root);
        int codeOffset = this.root instanceof UsingDefs ? ((UsingDefs)this.root).getCodeOffset() : -1;
        return new UsingDirectivesImpl(null, flattenView, this.root, codeOffset);
    }

    private Map<String, List<Value<?>>> visitUsingsFlat(UsingTree root) {
        if (root instanceof UsingDefs) {
            return ((UsingDefs)root).getUsingDefs().stream().flatMap(ud -> this.visitUsingsFlat((UsingTree)ud).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, this::merge));
        }
        if (root instanceof UsingDef) {
            HashMap map = new HashMap();
            List<KeyValue<String, List<Value<?>>>> keyValueList = this.visitSettingFlat((UsingDef)root);
            keyValueList.forEach(kv -> map.merge((String)kv.getKey(), (List)kv.getValue(), this::merge));
            return map;
        }
        this.reporter.error(root.getPosition(), "Provided AST cannot be processed.");
        return null;
    }

    private List<KeyValue<String, List<Value<?>>>> visitSettingFlat(UsingDef using) {
        String key = using.getKey();
        if (using.getValue() == null) {
            return new ArrayList();
        }
        return new ArrayList(Collections.singletonList(new KeyValue(key, this.parseValue(using.getValue()))));
    }

    private List<Value<?>> parseValue(UsingValue value) {
        if (value instanceof UsingPrimitive) {
            ArrayList lst = new ArrayList();
            if (value instanceof BooleanLiteral) {
                lst.add(new BooleanValue(((BooleanLiteral)value).getValue(), value, ((UsingPrimitive)value).getScope()));
            } else if (value instanceof StringLiteral) {
                lst.add(new StringValue(((StringLiteral)value).getValue(), value, ((UsingPrimitive)value).getScope()));
            } else {
                lst.add(new EmptyValue(value, ((UsingPrimitive)value).getScope()));
            }
            return lst;
        }
        return this.parseValues((UsingValues)value);
    }

    private List<Value<?>> parseValues(UsingValues value) {
        return value.values.stream().flatMap(p -> this.parseValue((UsingValue)p).stream()).collect(Collectors.toList());
    }

    private List<Value<?>> merge(List<Value<?>> v1, List<Value<?>> v2) {
        ArrayList copied = new ArrayList(v1);
        copied.addAll(v2);
        return copied;
    }

    private Map<Path, List<Value<?>>> getFlatView(UsingTree root) {
        Map<String, List<Value<?>>> intermediate = this.visitUsingsFlat(root);
        return intermediate.entrySet().stream().collect(Collectors.toMap(e -> new Path(Arrays.asList(((String)e.getKey()).split("\\."))), Map.Entry::getValue));
    }
}

