/*
 * Decompiled with CFR 0.152.
 */
package scala.build.testrunner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.testrunner.AsmTestRunner;
import scala.build.testrunner.TestRunner$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class AsmTestRunner$
implements Serializable {
    public static final AsmTestRunner$ MODULE$ = new AsmTestRunner$();

    private AsmTestRunner$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AsmTestRunner$.class);
    }

    public Option<Fingerprint> matchFingerprints(String className, Function0<InputStream> byteCode, Seq<Fingerprint> fingerprints, AsmTestRunner.ParentInspector parentInspector) {
        boolean definitelyNoTests;
        AsmTestRunner.TestClassChecker checker = new AsmTestRunner.TestClassChecker();
        try (InputStream is0 = null;){
            is0 = (InputStream)byteCode.apply();
            ClassReader reader = new ClassReader(is0);
            reader.accept((ClassVisitor)checker, 0);
        }
        boolean isModule = className.endsWith("$");
        boolean hasPublicConstructors = checker.publicConstructorCount() > 0;
        boolean bl = definitelyNoTests = checker.isAbstract() || checker.isInterface() || checker.publicConstructorCount() > 1 || isModule == hasPublicConstructors;
        if (definitelyNoTests) {
            return None$.MODULE$;
        }
        return fingerprints.find((Function1 & Serializable)x$1 -> {
            Fingerprint fingerprint = x$1;
            if (fingerprint instanceof SubclassFingerprint) {
                SubclassFingerprint f = (SubclassFingerprint)fingerprint;
                return f.isModule() == isModule && parentInspector.allParents(checker.name()).contains((Object)f.superclassName().replace('.', '/'));
            }
            if (fingerprint instanceof AnnotatedFingerprint) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            throw new MatchError((Object)fingerprint);
        });
    }

    public Iterator<Tuple2<String, Function0<InputStream>>> listClassesByteCode(Path classPathEntry, boolean keepJars) {
        if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            try (Stream<Path> stream = null;){
                stream = Files.walk(classPathEntry, Integer.MAX_VALUE, new FileVisitOption[0]);
                iterator = CollectionConverters$.MODULE$.IteratorHasAsScala(stream.iterator()).asScala().filter((Function1 & Serializable)_$1 -> _$1.getFileName().toString().endsWith(".class")).map((Function1 & Serializable)_$2 -> _$2.toAbsolutePath()).map((Function1 & Serializable)p -> {
                    String clsName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(classPathEntry.relativize((Path)p).toString()), ".class");
                    return Tuple2$.MODULE$.apply((Object)clsName, (Function0 & Serializable)() -> this.openStream$1((Path)p));
                }).toVector().iterator();
            }
            return iterator;
        }
        if (keepJars && Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            byte[] buf = new byte[16384];
            ObjectRef zf = ObjectRef.create(null);
            try {
                ZipFile zipFile = new ZipFile(classPathEntry.toFile());
                zf.elem = zipFile;
                zipFile = null;
                iterator = CollectionConverters$.MODULE$.EnumerationHasAsScala(((ZipFile)zf.elem).entries()).asScala().filter((Function1 & Serializable)_$3 -> _$3.getName().endsWith(".class")).map((Function1 & Serializable)ent -> {
                    Tuple2 tuple2;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (InputStream is = null;){
                        is = ((ZipFile)zf$1.elem).getInputStream((ZipEntry)ent);
                        int read = -1;
                        while ((read = is.read(buf)) >= 0) {
                            baos.write(buf, 0, read);
                        }
                        String clsName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ent.getName()), ".class");
                        tuple2 = Tuple2$.MODULE$.apply((Object)clsName, (Function0 & Serializable)() -> this.openStream$2(baos));
                    }
                    return tuple2;
                }).toVector().iterator();
            }
            finally {
                if ((ZipFile)zf.elem != null) {
                    ((ZipFile)zf.elem).close();
                }
            }
            return iterator;
        }
        return package$.MODULE$.Iterator().empty();
    }

    public Iterator<Tuple2<String, Function0<InputStream>>> listClassesByteCode(Seq<Path> classPath, boolean keepJars) {
        return classPath.iterator().flatMap((Function1 & Serializable)_$4 -> this.listClassesByteCode((Path)_$4, keepJars));
    }

    public Option<byte[]> findInClassPath(Path classPathEntry, String name) {
        if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            Path p = classPathEntry.resolve(name);
            if (Files.isRegularFile(p, new LinkOption[0])) {
                return Some$.MODULE$.apply((Object)Files.readAllBytes(p));
            }
            return None$.MODULE$;
        }
        if (Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            Option option;
            byte[] buf = new byte[16384];
            ObjectRef zf = ObjectRef.create(null);
            try {
                ZipFile zipFile = new ZipFile(classPathEntry.toFile());
                zf.elem = zipFile;
                zipFile = null;
                option = Option$.MODULE$.apply((Object)((ZipFile)zf.elem).getEntry(name)).map((Function1 & Serializable)ent -> {
                    byte[] byArray;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (InputStream is = null;){
                        is = ((ZipFile)zf$2.elem).getInputStream((ZipEntry)ent);
                        int read = -1;
                        while ((read = is.read(buf)) >= 0) {
                            baos.write(buf, 0, read);
                        }
                        byArray = baos.toByteArray();
                    }
                    return byArray;
                });
            }
            finally {
                if ((ZipFile)zf.elem != null) {
                    ((ZipFile)zf.elem).close();
                }
            }
            return option;
        }
        return None$.MODULE$;
    }

    public Option<byte[]> findInClassPath(Seq<Path> classPath, String name) {
        return classPath.iterator().flatMap((Function1 & Serializable)_$5 -> this.findInClassPath((Path)_$5, name).iterator()).take(1).toList().headOption();
    }

    public Option<String> findFrameworkService(Seq<Path> classPath) {
        return this.findInClassPath(classPath, "META-INF/services/sbt.testing.Framework").map((Function1 & Serializable)b -> new String((byte[])b, StandardCharsets.UTF_8));
    }

    public Option<String> findFramework(Seq<Path> classPath, Seq<String> preferredClasses) {
        AsmTestRunner.ParentInspector parentInspector = new AsmTestRunner.ParentInspector(classPath);
        return this.findFramework(classPath, preferredClasses, parentInspector);
    }

    public Option<String> findFramework(Seq<Path> classPath, Seq<String> preferredClasses, AsmTestRunner.ParentInspector parentInspector) {
        Iterator preferredClassesByteCode = preferredClasses.iterator().map((Function1 & Serializable)_$6 -> _$6.replace('.', '/')).flatMap((Function1 & Serializable)name -> this.findInClassPath(classPath, new StringBuilder(6).append((String)name).append(".class").toString()).iterator().map((Function1 & Serializable)b -> Tuple2$.MODULE$.apply(name, (Function0 & Serializable)() -> this.openStream$3((byte[])b))));
        return preferredClassesByteCode.$plus$plus(() -> this.findFramework$$anonfun$1(classPath)).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String moduleInfo = string;
                if (moduleInfo.contains("module-info")) {
                    return package$.MODULE$.Iterator().empty();
                }
                String name = string;
                Function0 is = (Function0)tuple2._2();
                AsmTestRunner.TestClassChecker checker = new AsmTestRunner.TestClassChecker();
                try (InputStream is0 = null;){
                    is0 = (InputStream)is.apply();
                    ClassReader reader = new ClassReader(is0);
                    reader.accept((ClassVisitor)checker, 0);
                }
                boolean isFramework = parentInspector.allParents(name).contains((Object)"sbt/testing/Framework");
                if (isFramework && !checker.isAbstract() && checker.publicConstructorCount() == 1) {
                    return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                }
                return package$.MODULE$.Iterator().empty();
            }
            throw new MatchError((Object)tuple2);
        }).take(1).toList().headOption();
    }

    public Iterator<TaskDef> taskDefs(Seq<Path> classPath, boolean keepJars, Seq<Fingerprint> fingerprints, AsmTestRunner.ParentInspector parentInspector) {
        return this.listClassesByteCode(classPath, keepJars).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Function0 is = (Function0)tuple2._2();
                return this.matchFingerprints(name, (Function0<InputStream>)is, fingerprints, parentInspector).map((Function1 & Serializable)_$8 -> Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(name), "$"), _$8)).iterator();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String clsName = (String)tuple2._1();
                Fingerprint fp = (Fingerprint)tuple2._2();
                return new TaskDef(clsName.replace('/', '.').replace('\\', '.'), fp, false, new Selector[]{new SuiteSelector()});
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void main(String[] args) {
        boolean failed;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Seq<Path> classPath = TestRunner$.MODULE$.classPath(classLoader);
        AsmTestRunner.ParentInspector parentCache = new AsmTestRunner.ParentInspector(classPath);
        String frameworkClassName = ((String)this.findFrameworkService(classPath).orElse(() -> this.$anonfun$4(classPath, parentCache)).getOrElse(this::$anonfun$5)).replace('/', '.').replace('\\', '.');
        Framework framework = (Framework)classLoader.loadClass(frameworkClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        PrintStream out = System.out;
        Object object = Predef$.MODULE$.refArrayOps((Object[])framework.fingerprints());
        TaskDef[] taskDefs0 = (TaskDef[])this.taskDefs(classPath, false, (Seq<Fingerprint>)ArrayOps$.MODULE$.toIndexedSeq$extension(object), parentCache).toArray(ClassTag$.MODULE$.apply(TaskDef.class));
        Runner runner = framework.runner(new String[0], new String[0], classLoader);
        Task[] initialTasks = runner.tasks(taskDefs0);
        Seq<Event> events = TestRunner$.MODULE$.runTasks((Seq<Task>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)initialTasks), out);
        String doneMsg = runner.done();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(doneMsg))) {
            out.println(doneMsg);
        }
        if (failed = events.exists((Function1 & Serializable)ev -> {
            Status status = ev.status();
            Status status2 = Status.Error;
            if (status == null) {
                if (status2 == null) return true;
            } else if (status.equals(status2)) return true;
            Status status3 = ev.status();
            Status status4 = Status.Failure;
            if (status3 == null) {
                if (status4 == null) return true;
            } else if (status3.equals(status4)) return true;
            Status status5 = ev.status();
            Status status6 = Status.Canceled;
            if (status5 != null) {
                if (!status5.equals(status6)) return false;
                return true;
            }
            if (status6 == null) return true;
            return false;
        })) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    private final InputStream openStream$1(Path p$1) {
        return Files.newInputStream(p$1, new OpenOption[0]);
    }

    private final ByteArrayInputStream openStream$2(ByteArrayOutputStream baos$1) {
        return new ByteArrayInputStream(baos$1.toByteArray());
    }

    private final ByteArrayInputStream openStream$3(byte[] b$1) {
        return new ByteArrayInputStream(b$1);
    }

    private final IterableOnce findFramework$$anonfun$1(Seq classPath$2) {
        return this.listClassesByteCode((Seq<Path>)classPath$2, true);
    }

    private final Option $anonfun$4(Seq classPath$3, AsmTestRunner.ParentInspector parentCache$1) {
        return this.findFramework((Seq<Path>)classPath$3, TestRunner$.MODULE$.commonTestFrameworks(), parentCache$1);
    }

    private final String $anonfun$5() {
        throw scala.sys.package$.MODULE$.error("No test framework found");
    }
}

