/*
 * Decompiled with CFR 0.152.
 */
package scala.build.options;

import coursier.Versions;
import coursier.Versions$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import coursier.core.Module;
import coursier.core.Repository;
import coursier.core.Version;
import coursier.core.Version$;
import coursier.parse.ModuleParser$;
import coursier.util.Artifact;
import coursier.util.Artifact$;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import os.Path$;
import os.PathConvertible;
import os.ReadablePath;
import os.read;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.build.EitherCps;
import scala.build.EitherCps$;
import scala.build.errors.BuildException;
import scala.build.errors.InvalidBinaryScalaVersionError;
import scala.build.errors.NoValidScalaVersionFoundError;
import scala.build.errors.ScalaVersionError;
import scala.build.errors.ScalaVersionError$;
import scala.build.errors.UnsupportedScalaVersionError;
import scala.build.internal.Constants$;
import scala.build.internal.Regexes$;
import scala.build.internal.Util$;
import scala.build.options.ScalaVersionUtil;
import scala.build.options.ScalaVersionUtil$CheckNightly$;
import scala.build.options.ScalaVersionUtil$GetNightly$;
import scala.build.options.ScalaVersionUtil$GetNightly$Scala2Repo$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class ScalaVersionUtil$
implements Serializable {
    public static final ScalaVersionUtil$GetNightly$ GetNightly;
    public static final ScalaVersionUtil$CheckNightly$ CheckNightly;
    public static final ScalaVersionUtil$ MODULE$;

    private ScalaVersionUtil$() {
    }

    static {
        MODULE$ = new ScalaVersionUtil$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalaVersionUtil$.class);
    }

    public Module scala$build$options$ScalaVersionUtil$$$scala2Library() {
        return (Module)ModuleParser$.MODULE$.module("org.scala-lang:scala-library", Constants$.MODULE$.defaultScalaVersion()).getOrElse(ScalaVersionUtil$::scala2Library$$anonfun$1);
    }

    public Module scala$build$options$ScalaVersionUtil$$$scala3Library() {
        return (Module)ModuleParser$.MODULE$.module("org.scala-lang:scala3-library_3", Constants$.MODULE$.defaultScalaVersion()).getOrElse(ScalaVersionUtil$::scala3Library$$anonfun$1);
    }

    public String scala212Nightly() {
        return "2.12.nightly";
    }

    public List<String> scala213Nightly() {
        return (List)new .colon.colon((Object)"2.13.nightly", (List)new .colon.colon((Object)"2.nightly", (List)Nil$.MODULE$));
    }

    public String scala3Nightly() {
        return "3.nightly";
    }

    public List<String> scala3Lts() {
        return (List)new .colon.colon((Object)"3.lts", (List)new .colon.colon((Object)"lts", (List)Nil$.MODULE$));
    }

    public List<String> scala2Lts() {
        return (List)new .colon.colon((Object)"2.13.lts", (List)new .colon.colon((Object)"2.12.lts", (List)new .colon.colon((Object)"2.lts", (List)Nil$.MODULE$)));
    }

    public Either<ArtifactError, File> fileWithTtl0(FileCache<Task> cache, Artifact artifact) {
        return (Either)cache.logger().use(() -> ScalaVersionUtil$.fileWithTtl0$$anonfun$1(cache, artifact));
    }

    public Versions.Result versions(FileCache<Task> cache, Module module, Seq<Repository> repositories, Option<Duration> ttl2) {
        FileCache cacheWithTtl = (FileCache)ttl2.map((Function1 & Serializable)ttl -> cache.withTtl(ttl)).getOrElse(() -> ScalaVersionUtil$.$anonfun$2(cache));
        return (Versions.Result)cacheWithTtl.logger().use(() -> ScalaVersionUtil$.versions$$anonfun$1(cacheWithTtl, module, repositories));
    }

    public Seq<Repository> versions$default$3(FileCache<Task> cache) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<Duration> versions$default$4(FileCache<Task> cache) {
        return None$.MODULE$;
    }

    public Versions.Result versionsWithTtl0(FileCache<Task> cache, Module module, Seq<Repository> repositories) {
        return this.versions(cache, module, repositories, (Option<Duration>)Some$.MODULE$.apply((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()));
    }

    public Seq<Repository> versionsWithTtl0$default$3(FileCache<Task> cache) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Either<BuildException, BoxedUnit> verify(Versions.Result versionsResult, String versionString) {
        if (versionsResult.versions().available().contains((Object)versionString)) {
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return package$.MODULE$.Left().apply((Object)new NoValidScalaVersionFoundError(versionString));
    }

    public Either<ScalaVersionError, String> validateNonStable(String scalaVersionStringArg, FileCache<Task> cache, Seq<Repository> repositories) {
        Seq<String> versionPool = this.allMatchingVersions((Option<String>)Some$.MODULE$.apply((Object)scalaVersionStringArg), cache, repositories);
        if (versionPool.contains((Object)scalaVersionStringArg)) {
            if (this.isSupportedVersion(scalaVersionStringArg)) {
                return package$.MODULE$.Right().apply((Object)scalaVersionStringArg);
            }
            return package$.MODULE$.Left().apply((Object)new UnsupportedScalaVersionError(scalaVersionStringArg));
        }
        return package$.MODULE$.Left().apply((Object)new InvalidBinaryScalaVersionError(scalaVersionStringArg));
    }

    public Either<ScalaVersionError, String> validateStable(String scalaVersionStringArg, FileCache<Task> cache, Seq<Repository> repositories) {
        String prefix;
        Seq versionPool = (Seq)this.allMatchingVersions((Option<String>)Some$.MODULE$.apply((Object)scalaVersionStringArg), cache, repositories).filter((Function1 & Serializable)version -> MODULE$.isStable((String)version));
        Seq matchingStableVersions = (Seq)((IterableOps)versionPool.filter(arg_0 -> ScalaVersionUtil$.$anonfun$12(prefix = Util$.MODULE$.isFullScalaVersion(scalaVersionStringArg) ? scalaVersionStringArg : (scalaVersionStringArg.endsWith(".") ? scalaVersionStringArg : new StringBuilder(1).append(scalaVersionStringArg).append(".").toString()), arg_0))).map((Function1 & Serializable)_$22 -> Version$.MODULE$.apply(_$22));
        if (matchingStableVersions.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)new InvalidBinaryScalaVersionError(scalaVersionStringArg));
        }
        Seq supportedMatchingStableVersions = (Seq)matchingStableVersions.filter((Function1 & Serializable)v -> MODULE$.isSupportedVersion(v.repr()));
        Option option = supportedMatchingStableVersions.find((Function1 & Serializable)_$23 -> {
            String string = _$23.repr();
            String string2 = scalaVersionStringArg;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            Version v2 = (Version)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)v2.repr());
        }
        if (None$.MODULE$.equals(option) && supportedMatchingStableVersions.nonEmpty()) {
            return package$.MODULE$.Right().apply((Object)((Version)supportedMatchingStableVersions.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).repr());
        }
        return package$.MODULE$.Left().apply((Object)new UnsupportedScalaVersionError(scalaVersionStringArg));
    }

    private boolean isSupportedVersion(String version) {
        return version.startsWith("2.12.") || version.startsWith("2.13.") || version.startsWith("3.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScala2Nightly(String version) {
        if (Regexes$.MODULE$.scala2NightlyRegex().unapplySeq((CharSequence)version).isDefined()) return true;
        String string = this.scala212Nightly();
        if (!((List)this.scala213Nightly().$plus$colon((Object)string)).contains((Object)version)) return false;
        return true;
    }

    public boolean isScala3Nightly(String version) {
        return version.startsWith("3") && version.endsWith("-NIGHTLY");
    }

    public boolean isStable(String version) {
        return !StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(version), (Function1 & Serializable)_$24 -> RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$24))));
    }

    public Seq<String> allMatchingVersions(Option<String> maybeScalaVersionArg, FileCache<Task> cache, Seq<Repository> repositories) {
        Seq modules = maybeScalaVersionArg.contains((Object)"2") || maybeScalaVersionArg.exists((Function1 & Serializable)_$25 -> _$25.startsWith("2.")) ? (Seq)((SeqOps)new .colon.colon((Object)this.scala$build$options$ScalaVersionUtil$$$scala2Library(), (List)Nil$.MODULE$)) : (maybeScalaVersionArg.contains((Object)"3") || maybeScalaVersionArg.exists((Function1 & Serializable)_$26 -> _$26.startsWith("3.")) ? (Seq)((SeqOps)new .colon.colon((Object)this.scala$build$options$ScalaVersionUtil$$$scala3Library(), (List)Nil$.MODULE$)) : (Seq)((SeqOps)new .colon.colon((Object)this.scala$build$options$ScalaVersionUtil$$$scala2Library(), (List)new .colon.colon((Object)this.scala$build$options$ScalaVersionUtil$$$scala3Library(), (List)Nil$.MODULE$))));
        return (Seq)((SeqOps)modules.flatMap((Function1 & Serializable)mod -> {
            Versions.Result versions = (Versions.Result)cache.logger().use(() -> ScalaVersionUtil$.$anonfun$17(cache, mod, repositories));
            return versions.versions().available();
        })).distinct();
    }

    public Version asVersion(String sv) {
        return Version$.MODULE$.apply(sv);
    }

    private static final Module scala2Library$$anonfun$1() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private static final Module scala3Library$$anonfun$1() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private static final Either fileWithTtl0$$anonfun$1(FileCache cache$1, Artifact artifact$1) {
        Either either;
        try {
            Object object = cache$1.withTtl((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()).file(artifact$1).run();
            either = (Either)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun((ExecutionContext)cache$1.ec());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new Exception(e);
            }
            throw throwable;
        }
        return either;
    }

    private static final FileCache $anonfun$2(FileCache cache$3) {
        return cache$3;
    }

    private static final Versions.Result versions$$anonfun$1(FileCache cacheWithTtl$1, Module module$1, Seq repositories$1) {
        Object object = Versions$.MODULE$.apply((Cache)cacheWithTtl$1, Task$.MODULE$.sync()).withModule(module$1).addRepositories(repositories$1).result();
        return (Versions.Result)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun((ExecutionContext)cacheWithTtl$1.ec());
    }

    public static final /* synthetic */ byte[] scala$build$options$ScalaVersionUtil$GetNightly$$$_$downloadScala2RepoPage$$anonfun$1(FileCache cache$4, EitherCps evidence$3) {
        String scala2NightlyRepo = "https://scala-ci.typesafe.com/ui/api/v1/ui/nativeBrowser/scala-integration/org/scala-lang/scala-compiler";
        Artifact artifact = Artifact$.MODULE$.apply(scala2NightlyRepo).withChanging(true);
        Either res = MODULE$.fileWithTtl0((FileCache<Task>)cache$4, artifact).left().map((Function1 & Serializable)err -> {
            String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Unable to compute the latest Scala 2 nightly version.\n                 |Throws error during downloading web page repository for Scala 2."));
            return new ScalaVersionError(msg, ScalaVersionError$.MODULE$.$lessinit$greater$default$2(), (Throwable)err);
        });
        File res0 = (File)EitherCps$.MODULE$.value(evidence$3, res);
        byte[] content = read.bytes$.MODULE$.apply((ReadablePath)Path$.MODULE$.apply((Object)res0, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$));
        return content;
    }

    private static final String scala2$$anonfun$1$$anonfun$1(String versionPrefix$3) {
        String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(122).append("|Unable to compute the latest Scala ").append(versionPrefix$3).append(" nightly version.\n                      |Pass explicitly full Scala 2 nightly version.").toString()));
        throw new ScalaVersionError(msg, ScalaVersionError$.MODULE$.$lessinit$greater$default$2(), ScalaVersionError$.MODULE$.$lessinit$greater$default$3());
    }

    public static final /* synthetic */ String scala$build$options$ScalaVersionUtil$GetNightly$$$_$scala2$$anonfun$1(FileCache cache$5, String versionPrefix$1, EitherCps evidence$4) {
        byte[] webPageScala2Repo = (byte[])EitherCps$.MODULE$.value(evidence$4, ScalaVersionUtil$GetNightly$.MODULE$.scala$build$options$ScalaVersionUtil$GetNightly$$$downloadScala2RepoPage((FileCache<Task>)cache$5));
        ScalaVersionUtil.GetNightly.Scala2Repo.ScalaVersionsMetaData scala2Repo = (ScalaVersionUtil.GetNightly.Scala2Repo.ScalaVersionsMetaData)com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray(webPageScala2Repo, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray$default$2(), ScalaVersionUtil$GetNightly$Scala2Repo$.MODULE$.codec());
        List<ScalaVersionUtil.GetNightly.Scala2Repo.ScalaVersion> versions = scala2Repo.children();
        List sortedVersion = (List)versions.filter((Function1 & Serializable)_$14 -> _$14.name().startsWith(versionPrefix$1)).filterNot((Function1 & Serializable)_$15 -> _$15.name().contains("pre")).sortBy((Function1 & Serializable)_$16 -> _$16.lastModified(), (Ordering)Ordering.Long$.MODULE$);
        Option latestNightly = sortedVersion.lastOption().map((Function1 & Serializable)_$17 -> _$17.name());
        return (String)latestNightly.getOrElse(() -> ScalaVersionUtil$.scala2$$anonfun$1$$anonfun$1(versionPrefix$1));
    }

    public static final /* synthetic */ boolean scala$build$options$ScalaVersionUtil$GetNightly$$$_$_$$anonfun$8(String _$18) {
        return _$18.endsWith("-NIGHTLY");
    }

    public static final /* synthetic */ boolean scala$build$options$ScalaVersionUtil$GetNightly$$$_$_$$anonfun$9(String threeSubBinaryNum$1, String _$19) {
        return _$19.startsWith(new StringBuilder(3).append("3.").append(threeSubBinaryNum$1).append(".").toString());
    }

    public static final /* synthetic */ Version scala$build$options$ScalaVersionUtil$GetNightly$$$_$_$$anonfun$10(String _$20) {
        return Version$.MODULE$.apply(_$20);
    }

    private static final /* synthetic */ boolean $anonfun$12(String prefix$1, String _$21) {
        return _$21.startsWith(prefix$1);
    }

    private static final Versions.Result $anonfun$17(FileCache cache$7, Module mod$1, Seq repositories$3) {
        Versions.Result result;
        try {
            Object object = Versions$.MODULE$.apply((Cache)cache$7, Task$.MODULE$.sync()).withModule(mod$1).addRepositories(repositories$3).result();
            result = (Versions.Result)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun((ExecutionContext)cache$7.ec());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new Exception(e);
            }
            throw throwable;
        }
        return result;
    }
}

