/*
 * Decompiled with CFR 0.152.
 */
package scala.build.options;

import coursier.Versions;
import coursier.Versions$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import coursier.core.Module;
import coursier.core.Repository;
import coursier.core.Version;
import coursier.core.Version$;
import coursier.parse.ModuleParser$;
import coursier.util.Artifact;
import coursier.util.Task;
import coursier.util.Task$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.build.errors.BuildException;
import scala.build.errors.InvalidBinaryScalaVersionError;
import scala.build.errors.NoValidScalaVersionFoundError;
import scala.build.errors.ScalaVersionError;
import scala.build.errors.UnsupportedScalaVersionError;
import scala.build.internal.Constants$;
import scala.build.internal.Regexes$;
import scala.build.internal.Util$;
import scala.build.options.ScalaVersionUtil$CheckNightly$;
import scala.build.options.ScalaVersionUtil$GetNightly$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class ScalaVersionUtil$
implements Serializable {
    public static final ScalaVersionUtil$GetNightly$ GetNightly;
    public static final ScalaVersionUtil$CheckNightly$ CheckNightly;
    public static final ScalaVersionUtil$ MODULE$;

    private ScalaVersionUtil$() {
    }

    static {
        MODULE$ = new ScalaVersionUtil$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalaVersionUtil$.class);
    }

    public Module scala$build$options$ScalaVersionUtil$$$scala2Library() {
        return (Module)ModuleParser$.MODULE$.module("org.scala-lang:scala-library", Constants$.MODULE$.defaultScalaVersion()).getOrElse(this::scala2Library$$anonfun$1);
    }

    public Module scala$build$options$ScalaVersionUtil$$$scala3Library() {
        return (Module)ModuleParser$.MODULE$.module("org.scala-lang:scala3-library_3", Constants$.MODULE$.defaultScalaVersion()).getOrElse(this::scala3Library$$anonfun$1);
    }

    public String scala212Nightly() {
        return "2.12.nightly";
    }

    public List<String> scala213Nightly() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2.13.nightly", "2.nightly"}));
    }

    public String scala3Nightly() {
        return "3.nightly";
    }

    public List<String> scala3Lts() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"3.lts", "lts"}));
    }

    public List<String> scala2Lts() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2.13.lts", "2.12.lts", "2.lts"}));
    }

    public Either<ArtifactError, File> fileWithTtl0(FileCache<Function1> cache, Artifact artifact) {
        return (Either)cache.logger().use(() -> this.fileWithTtl0$$anonfun$1(cache, artifact));
    }

    public Versions.Result versions(FileCache<Function1> cache, Module module, Seq<Repository> repositories, Option<Duration> ttl2) {
        FileCache cacheWithTtl = (FileCache)ttl2.map((Function1 & Serializable)ttl -> cache.withTtl(ttl)).getOrElse(() -> this.$anonfun$2(cache));
        return (Versions.Result)cacheWithTtl.logger().use(() -> this.versions$$anonfun$1(cacheWithTtl, module, repositories));
    }

    public Seq<Repository> versions$default$3(FileCache<Function1> cache) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<Duration> versions$default$4(FileCache<Function1> cache) {
        return None$.MODULE$;
    }

    public Versions.Result versionsWithTtl0(FileCache<Function1> cache, Module module, Seq<Repository> repositories) {
        return this.versions(cache, module, repositories, (Option<Duration>)Some$.MODULE$.apply((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()));
    }

    public Seq<Repository> versionsWithTtl0$default$3(FileCache<Function1> cache) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Either<BuildException, BoxedUnit> verify(Versions.Result versionsResult, String versionString) {
        if (versionsResult.versions().available().contains((Object)versionString)) {
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return package$.MODULE$.Left().apply((Object)new NoValidScalaVersionFoundError(versionString));
    }

    public Either<ScalaVersionError, String> validateNonStable(String scalaVersionStringArg, FileCache<Function1> cache, Seq<Repository> repositories) {
        Seq<String> versionPool = this.allMatchingVersions((Option<String>)Some$.MODULE$.apply((Object)scalaVersionStringArg), cache, repositories);
        if (versionPool.contains((Object)scalaVersionStringArg)) {
            if (this.isSupportedVersion(scalaVersionStringArg)) {
                return package$.MODULE$.Right().apply((Object)scalaVersionStringArg);
            }
            return package$.MODULE$.Left().apply((Object)new UnsupportedScalaVersionError(scalaVersionStringArg));
        }
        return package$.MODULE$.Left().apply((Object)new InvalidBinaryScalaVersionError(scalaVersionStringArg));
    }

    public Either<ScalaVersionError, String> validateStable(String scalaVersionStringArg, FileCache<Function1> cache, Seq<Repository> repositories) {
        String prefix;
        Seq versionPool = (Seq)this.allMatchingVersions((Option<String>)Some$.MODULE$.apply((Object)scalaVersionStringArg), cache, repositories).filter((Function1 & Serializable)version -> this.isStable((String)version));
        Seq matchingStableVersions = (Seq)((IterableOps)versionPool.filter(arg_0 -> this.$anonfun$12(prefix = Util$.MODULE$.isFullScalaVersion(scalaVersionStringArg) ? scalaVersionStringArg : (scalaVersionStringArg.endsWith(".") ? scalaVersionStringArg : new StringBuilder(1).append(scalaVersionStringArg).append(".").toString()), arg_0))).map((Function1 & Serializable)_$22 -> Version$.MODULE$.apply(_$22));
        if (matchingStableVersions.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)new InvalidBinaryScalaVersionError(scalaVersionStringArg));
        }
        Seq supportedMatchingStableVersions = (Seq)matchingStableVersions.filter((Function1 & Serializable)v -> this.isSupportedVersion(v.repr()));
        Option option = supportedMatchingStableVersions.find((Function1 & Serializable)_$23 -> {
            String string = _$23.repr();
            String string2 = scalaVersionStringArg;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            Version v2 = (Version)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)v2.repr());
        }
        if (None$.MODULE$.equals(option) && supportedMatchingStableVersions.nonEmpty()) {
            return package$.MODULE$.Right().apply((Object)((Version)supportedMatchingStableVersions.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).repr());
        }
        return package$.MODULE$.Left().apply((Object)new UnsupportedScalaVersionError(scalaVersionStringArg));
    }

    private boolean isSupportedVersion(String version) {
        return version.startsWith("2.12.") || version.startsWith("2.13.") || version.startsWith("3.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScala2Nightly(String version) {
        if (Regexes$.MODULE$.scala2NightlyRegex().unapplySeq((CharSequence)version).isDefined()) return true;
        String string = this.scala212Nightly();
        if (!((List)this.scala213Nightly().$plus$colon((Object)string)).contains((Object)version)) return false;
        return true;
    }

    public boolean isScala3Nightly(String version) {
        return version.startsWith("3") && version.endsWith("-NIGHTLY");
    }

    public boolean isStable(String version) {
        return !StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(version), (Function1 & Serializable)_$24 -> this.isStable$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$24)));
    }

    public Seq<String> allMatchingVersions(Option<String> maybeScalaVersionArg, FileCache<Function1> cache, Seq<Repository> repositories) {
        Seq modules = maybeScalaVersionArg.contains((Object)"2") || maybeScalaVersionArg.exists((Function1 & Serializable)_$25 -> _$25.startsWith("2.")) ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Module[]{this.scala$build$options$ScalaVersionUtil$$$scala2Library()})) : (maybeScalaVersionArg.contains((Object)"3") || maybeScalaVersionArg.exists((Function1 & Serializable)_$26 -> _$26.startsWith("3.")) ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Module[]{this.scala$build$options$ScalaVersionUtil$$$scala3Library()})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Module[]{this.scala$build$options$ScalaVersionUtil$$$scala2Library(), this.scala$build$options$ScalaVersionUtil$$$scala3Library()})));
        return (Seq)((SeqOps)modules.flatMap((Function1 & Serializable)mod -> {
            Versions.Result versions = (Versions.Result)cache.logger().use(() -> this.$anonfun$17(cache, mod, repositories));
            return versions.versions().available();
        })).distinct();
    }

    public Version asVersion(String sv) {
        return Version$.MODULE$.apply(sv);
    }

    private final Module scala2Library$$anonfun$1() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private final Module scala3Library$$anonfun$1() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private final Either fileWithTtl0$$anonfun$1(FileCache cache$1, Artifact artifact$1) {
        Either either;
        try {
            Object object = cache$1.withTtl((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()).file(artifact$1).run();
            either = (Either)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun((ExecutionContext)cache$1.ec());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new Exception(e);
            }
            throw throwable;
        }
        return either;
    }

    private final FileCache $anonfun$2(FileCache cache$3) {
        return cache$3;
    }

    private final Versions.Result versions$$anonfun$1(FileCache cacheWithTtl$1, Module module$1, Seq repositories$1) {
        Object object = Versions$.MODULE$.apply((Cache)cacheWithTtl$1, Task$.MODULE$.sync()).withModule(module$1).addRepositories(repositories$1).result();
        return (Versions.Result)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun((ExecutionContext)cacheWithTtl$1.ec());
    }

    private final /* synthetic */ boolean $anonfun$12(String prefix$1, String _$21) {
        return _$21.startsWith(prefix$1);
    }

    private final /* synthetic */ boolean isStable$$anonfun$1(char _$24) {
        return RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(_$24));
    }

    private final Versions.Result $anonfun$17(FileCache cache$7, Module mod$1, Seq repositories$3) {
        Versions.Result result;
        try {
            Object object = Versions$.MODULE$.apply((Cache)cache$7, Task$.MODULE$.sync()).withModule(mod$1).addRepositories(repositories$3).result();
            result = (Versions.Result)Task$.MODULE$.PlatformTaskOps(object == null ? null : ((Task)object).value()).unsafeRun((ExecutionContext)cache$7.ec());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new Exception(e);
            }
            throw throwable;
        }
        return result;
    }
}

