/*
 * Decompiled with CFR 0.152.
 */
package libsodiumjni;

import libsodiumjni.KeyPair;
import libsodiumjni.internal.SodiumApi;

public final class Sodium {
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (initialized) return;
        Class<Sodium> clazz = Sodium.class;
        synchronized (Sodium.class) {
            int n = SodiumApi.sodium_init();
            if (n != 0) {
                throw new RuntimeException("Cannot initialize libsodium");
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static KeyPair keyPair() {
        byte[] byArray;
        byte[] byArray2 = new byte[SodiumApi.crypto_box_public_key_bytes()];
        int n = SodiumApi.crypto_box_keypair(byArray2, byArray = new byte[SodiumApi.crypto_box_secret_key_bytes()]);
        if (n != 0) {
            throw new RuntimeException("Failed to generate key pair");
        }
        return new KeyPair(byArray2, byArray);
    }

    public static byte[] seal(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[SodiumApi.crypto_box_seal_bytes() + byArray.length];
        int n = SodiumApi.crypto_box_seal(byArray3, byArray, byArray.length, byArray2);
        if (n != 0) {
            throw new RuntimeException("Failed to seal message");
        }
        return byArray3;
    }

    public static byte[] sealOpen(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray.length < SodiumApi.crypto_box_seal_bytes()) {
            throw new RuntimeException("Invalid encrypted message length (" + byArray.length + ", should be > " + SodiumApi.crypto_box_seal_bytes() + ")");
        }
        byte[] byArray4 = new byte[byArray.length - SodiumApi.crypto_box_seal_bytes()];
        int n = SodiumApi.crypto_box_seal_open(byArray4, byArray, byArray.length, byArray2, byArray3);
        if (n != 0) {
            throw new RuntimeException("Failed to open seal");
        }
        return byArray4;
    }
}

