/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.config;

import com.github.plokhotnyuk.jsoniter_scala.core.package$;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Function1;
import scala.Option$;
import scala.Product;
import scala.cli.config.PasswordOption$;
import scala.cli.config.PasswordOption$Command$;
import scala.cli.config.PasswordOption$Env$;
import scala.cli.config.PasswordOption$File$;
import scala.cli.config.PasswordOption$Value$;
import scala.cli.config.Secret;
import scala.cli.config.Secret$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public abstract class PasswordOption
implements Product,
Serializable {
    public static int ordinal(PasswordOption passwordOption) {
        return PasswordOption$.MODULE$.ordinal(passwordOption);
    }

    public static Either<String, PasswordOption> parse(String string) {
        return PasswordOption$.MODULE$.parse(string);
    }

    public abstract Secret<String> get();

    public Secret<byte[]> getBytes() {
        return this.get().map((Function1 & Serializable)_$1 -> _$1.getBytes(StandardCharsets.UTF_8));
    }

    public abstract Secret<String> asString();

    public static final class Command
    extends PasswordOption {
        private final Seq command;

        public static Command apply(Seq<String> seq) {
            return PasswordOption$Command$.MODULE$.apply(seq);
        }

        public static Command fromProduct(Product product) {
            return PasswordOption$Command$.MODULE$.fromProduct(product);
        }

        public static Command unapply(Command command) {
            return PasswordOption$Command$.MODULE$.unapply(command);
        }

        public Command(Seq<String> command) {
            this.command = command;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Command)) return false;
            Command command = (Command)object;
            Seq<String> seq = this.command();
            Seq<String> seq2 = command.command();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Command;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Command";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "command";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<String> command() {
            return this.command;
        }

        @Override
        public Secret<String> get() {
            ProcessBuilder b = new ProcessBuilder((String[])Arrays$.MODULE$.seqToArray(this.command(), String.class));
            b.redirectInput(ProcessBuilder.Redirect.INHERIT);
            b.redirectError(ProcessBuilder.Redirect.INHERIT);
            b.redirectOutput(ProcessBuilder.Redirect.PIPE);
            Process p = b.start();
            InputStream is = p.getInputStream();
            int read = -1;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((read = is.read(buf)) >= 0) {
                if (read <= 0) continue;
                baos.write(buf, 0, read);
            }
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException(new StringBuilder(36).append("Error running command ").append(this.command().mkString(" ")).append(" (exit code: ").append(exitCode).append(")").toString());
            }
            String res = new String(baos.toByteArray());
            return Secret$.MODULE$.apply(res);
        }

        @Override
        public Secret<String> asString() {
            String json = package$.MODULE$.writeToString((Object)this.command().toList(), package$.MODULE$.writeToString$default$2(), PasswordOption$.MODULE$.commandCodec());
            return Secret$.MODULE$.apply(new StringBuilder(8).append("command:").append(json).toString());
        }

        public Command copy(Seq<String> command) {
            return new Command(command);
        }

        public Seq<String> copy$default$1() {
            return this.command();
        }

        public Seq<String> _1() {
            return this.command();
        }
    }

    public static final class Env
    extends PasswordOption {
        private final String name;

        public static Env apply(String string) {
            return PasswordOption$Env$.MODULE$.apply(string);
        }

        public static Env fromProduct(Product product) {
            return PasswordOption$Env$.MODULE$.fromProduct(product);
        }

        public static Env unapply(Env env) {
            return PasswordOption$Env$.MODULE$.unapply(env);
        }

        public Env(String name) {
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Env)) return false;
            Env env = (Env)object;
            String string = this.name();
            String string2 = env.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Env;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Env";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        @Override
        public Secret<String> get() {
            String value = (String)Option$.MODULE$.apply((Object)System.getenv(this.name())).getOrElse(this::$anonfun$1);
            return Secret$.MODULE$.apply(value);
        }

        @Override
        public Secret<String> asString() {
            return Secret$.MODULE$.apply(new StringBuilder(4).append("env:").append(this.name()).toString());
        }

        public Env copy(String name) {
            return new Env(name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }

        private final String $anonfun$1() {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(36).append("Error: environment variable ").append(this.name()).append(" not set").toString());
        }
    }

    public static final class File
    extends PasswordOption {
        private final Path path;

        public static File apply(Path path) {
            return PasswordOption$File$.MODULE$.apply(path);
        }

        public static File fromProduct(Product product) {
            return PasswordOption$File$.MODULE$.fromProduct(product);
        }

        public static File unapply(File file) {
            return PasswordOption$File$.MODULE$.unapply(file);
        }

        public File(Path path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof File)) return false;
            File file = (File)object;
            Path path = this.path();
            Path path2 = file.path();
            if (path != null) {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
            if (path2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof File;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "File";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        @Override
        public Secret<String> get() {
            String value = new String(Files.readAllBytes(this.path()), StandardCharsets.UTF_8);
            return Secret$.MODULE$.apply(value);
        }

        @Override
        public Secret<byte[]> getBytes() {
            byte[] value = Files.readAllBytes(this.path());
            return Secret$.MODULE$.apply(value);
        }

        @Override
        public Secret<String> asString() {
            return Secret$.MODULE$.apply(new StringBuilder(5).append("file:").append(this.path()).toString());
        }

        public File copy(Path path) {
            return new File(path);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public Path _1() {
            return this.path();
        }
    }

    public static final class Value
    extends PasswordOption {
        private final Secret value;

        public static Value apply(Secret<String> secret) {
            return PasswordOption$Value$.MODULE$.apply(secret);
        }

        public static Value fromProduct(Product product) {
            return PasswordOption$Value$.MODULE$.fromProduct(product);
        }

        public static Value unapply(Value value) {
            return PasswordOption$Value$.MODULE$.unapply(value);
        }

        public Value(Secret<String> value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Value)) return false;
            Value value = (Value)object;
            Secret<String> secret = this.value();
            Secret<String> secret2 = value.value();
            if (secret != null) {
                if (!((Object)secret).equals(secret2)) return false;
                return true;
            }
            if (secret2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Value;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Value";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Secret<String> value() {
            return this.value;
        }

        @Override
        public Secret<String> get() {
            return this.value();
        }

        @Override
        public Secret<String> asString() {
            return this.get().map((Function1 & Serializable)v -> new StringBuilder(6).append("value:").append((String)v).toString());
        }

        public Value copy(Secret<String> value) {
            return new Value(value);
        }

        public Secret<String> copy$default$1() {
            return this.value();
        }

        public Secret<String> _1() {
            return this.value();
        }
    }
}

