/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_4_2;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.virtualbox_4_2.IEventListener;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.IVirtualBox;
import org.virtualbox_4_2.LockType;
import org.virtualbox_4_2.PortPool;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_4_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_4_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxManager {
    private static PortPool pool = new PortPool(true);
    protected VboxPortType port;
    private IVirtualBox vbox;

    private VirtualBoxManager() {
    }

    public static void initPerThread() {
    }

    public static void deinitPerThread() {
    }

    public void connect(String string, String string2, String string3) {
        this.port = pool.getPort();
        try {
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
            String string4 = this.port.iWebsessionManagerLogon(string2, string3);
            this.vbox = new IVirtualBox(string4, this.port);
        }
        catch (Throwable throwable) {
            if (this.port != null && pool != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
            throw new VBoxException(throwable, throwable.getMessage());
        }
    }

    public void connect(String string, String string2, String string3, Map<String, Object> map, Map<String, Object> map2) {
        this.port = pool.getPort();
        try {
            ((BindingProvider)this.port).getRequestContext();
            if (map != null) {
                ((BindingProvider)this.port).getRequestContext().putAll(map);
            }
            if (map2 != null) {
                ((BindingProvider)this.port).getResponseContext().putAll(map2);
            }
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
            String string4 = this.port.iWebsessionManagerLogon(string2, string3);
            this.vbox = new IVirtualBox(string4, this.port);
        }
        catch (Throwable throwable) {
            if (this.port != null && pool != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
            throw new VBoxException(throwable, throwable.getMessage());
        }
    }

    public void disconnect() {
        try {
            if (this.vbox != null) {
                this.port.iWebsessionManagerLogoff(this.vbox.getWrapped());
            }
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
        finally {
            if (this.port != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
        }
    }

    public IVirtualBox getVBox() {
        return this.vbox;
    }

    public ISession getSessionObject() {
        if (this.vbox == null) {
            throw new RuntimeException("connect first");
        }
        try {
            String string = this.port.iWebsessionManagerGetSessionObject(this.vbox.getWrapped());
            return new ISession(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public ISession openMachineSession(IMachine iMachine) throws Exception {
        ISession iSession = this.getSessionObject();
        iMachine.lockMachine(iSession, LockType.Shared);
        return iSession;
    }

    public void closeMachineSession(ISession iSession) {
        if (iSession != null) {
            iSession.unlockMachine();
        }
    }

    public static synchronized VirtualBoxManager createInstance(String string) {
        return new VirtualBoxManager();
    }

    public IEventListener createListener(Object object) {
        throw new RuntimeException("no active listeners here");
    }

    public void cleanup() {
        this.disconnect();
        VirtualBoxManager.deinitPerThread();
    }

    public boolean progressBar(IProgress iProgress, int n) {
        long l = System.currentTimeMillis() + (long)n;
        while (!iProgress.getCompleted().booleanValue()) {
            iProgress.waitForCompletion(n);
            if (System.currentTimeMillis() < l) continue;
            return false;
        }
        return true;
    }

    public boolean startVm(String string, String string2, int n) {
        IMachine iMachine = this.vbox.findMachine(string);
        if (iMachine == null) {
            return false;
        }
        ISession iSession = this.getSessionObject();
        if (string2 == null) {
            string2 = "gui";
        }
        IProgress iProgress = iMachine.launchVMProcess(iSession, string2, "");
        this.progressBar(iProgress, n);
        iSession.unlockMachine();
        return true;
    }

    public void waitForEvents(long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

