/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_4_2;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.virtualbox_4_2.IUnknown;
import org.virtualbox_4_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    private static final char[] valToChar;
    private static final int[] charToVal;

    public static <T> List<T> wrap(Class<T> clazz, VboxPortType vboxPortType, List<String> list) {
        try {
            if (list == null) {
                return null;
            }
            Constructor<T> constructor = clazz.getConstructor(String.class, VboxPortType.class);
            ArrayList<T> arrayList = new ArrayList<T>(list.size());
            for (String string : list) {
                arrayList.add(constructor.newInstance(string, vboxPortType));
            }
            return arrayList;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static <T1, T2> List<T1> wrap2(Class<T1> clazz, Class<T2> clazz2, VboxPortType vboxPortType, List<T2> list) {
        try {
            if (list == null) {
                return null;
            }
            Constructor<T1> constructor = clazz.getConstructor(clazz2, VboxPortType.class);
            ArrayList<T1> arrayList = new ArrayList<T1>(list.size());
            for (T2 T2 : list) {
                arrayList.add(constructor.newInstance(T2, vboxPortType));
            }
            return arrayList;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static <T extends IUnknown> List<String> unwrap(List<T> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (IUnknown iUnknown : list) {
            arrayList.add(iUnknown.getWrapped());
        }
        return arrayList;
    }

    public static <T1 extends Enum<T1>, T2 extends Enum<T2>> List<T2> convertEnums(Class<T1> clazz, Class<T2> clazz2, List<T1> list) {
        try {
            if (list == null) {
                return null;
            }
            Method method = clazz2.getMethod("fromValue", String.class);
            ArrayList<Enum> arrayList = new ArrayList<Enum>(list.size());
            for (Enum enum_ : list) {
                arrayList.add((Enum)method.invoke(null, enum_.name()));
            }
            return arrayList;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static String encodeBase64(byte[] byArray) {
        int n;
        int n2;
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        int n3 = byArray.length / 3;
        int n4 = ((byArray.length - 1) / 3 + 1) * 4;
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = byArray[n5++] & 0xFF;
            cArray[n6++] = valToChar[n >> 2];
            int n7 = byArray[n5++] & 0xFF;
            cArray[n6++] = valToChar[n << 4 & 0x3F | n7 >> 4];
            int n8 = byArray[n5++] & 0xFF;
            cArray[n6++] = valToChar[n7 << 2 & 0x3F | n8 >> 6];
            cArray[n6++] = valToChar[n8 & 0x3F];
        }
        switch (byArray.length - n5) {
            case 0: {
                break;
            }
            case 1: {
                n2 = byArray[n5++] & 0xFF;
                cArray[n6++] = valToChar[n2 >> 2];
                cArray[n6++] = valToChar[n2 << 4 & 0x3F];
                cArray[n6++] = 61;
                cArray[n6++] = 61;
                break;
            }
            case 2: {
                n2 = byArray[n5++] & 0xFF;
                cArray[n6++] = valToChar[n2 >> 2];
                n = byArray[n5++] & 0xFF;
                cArray[n6++] = valToChar[n2 << 4 & 0x3F | n >> 4];
                cArray[n6++] = valToChar[n << 2 & 0x3F];
                cArray[n6++] = 61;
                break;
            }
            default: {
                throw new RuntimeException("bug!");
            }
        }
        return new String(cArray);
    }

    private static int skipInvalid(String string, int n) {
        while (charToVal[string.charAt(n)] < 0) {
            ++n;
        }
        return n;
    }

    public static byte[] decodeBase64(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (charToVal[c] >= 0) {
                ++n3;
            }
            if (c != '=') continue;
            ++n4;
        }
        if (n3 * 3 % 4 != 0) {
            throw new RuntimeException("invalid encoded string " + string);
        }
        n = n3 * 3 / 4 - n4;
        byte[] byArray = new byte[n];
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 / 4;
        for (int i = 0; i < n7; ++i) {
            n6 = Helper.skipInvalid(string, n6);
            char c = string.charAt(n6++);
            n6 = Helper.skipInvalid(string, n6);
            char c2 = string.charAt(n6++);
            n6 = Helper.skipInvalid(string, n6);
            char c3 = string.charAt(n6++);
            n6 = Helper.skipInvalid(string, n6);
            char c4 = string.charAt(n6++);
            byArray[n5++] = (byte)((charToVal[c] << 2 | charToVal[c2] >> 4) & 0xFF);
            if (n5 < byArray.length) {
                byArray[n5++] = (byte)((charToVal[c2] << 4 | charToVal[c3] >> 2) & 0xFF);
            }
            if (n5 >= byArray.length) continue;
            byArray[n5++] = (byte)((charToVal[c3] << 6 | charToVal[c4]) & 0xFF);
        }
        return byArray;
    }

    static {
        int n;
        valToChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        charToVal = new int[256];
        for (n = 0; n < charToVal.length; ++n) {
            Helper.charToVal[n] = -1;
        }
        for (n = 0; n < valToChar.length; ++n) {
            Helper.charToVal[Helper.valToChar[n]] = n;
        }
        Helper.charToVal[61] = 0;
    }
}

