/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class JavaSupport {
    private static final JavaSupportImpl impl = JavaSupport.findImpl();

    public static int getScaleFactor(@NotNull Graphics graphics) {
        return impl.getScaleFactor(graphics);
    }

    @NotNull
    public static Image createMultiResolutionImage(int n, int n2, @NotNull BufferedImage bufferedImage) {
        return impl.createMultiResolutionImage(n, n2, bufferedImage);
    }

    private static JavaSupportImpl findImpl() {
        int n = JavaSupport.obtainJavaVersion();
        System.err.println("Java version: " + n);
        String string = n >= 900000 ? "Java9Support" : "Java8Support";
        try {
            Class<?> clazz = Class.forName("org.violetlib.jnr.impl." + string);
            return (JavaSupportImpl)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unsupported Java version: " + n, exception);
        }
    }

    private static int obtainJavaVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            string = string.substring(2);
        }
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "._");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                int n3;
                String string2 = stringTokenizer.nextToken();
                int n4 = string2.indexOf("-");
                if (n4 > 0) {
                    string2 = string2.substring(0, n4);
                }
                int n5 = Integer.parseInt(string2);
                int n6 = n3 = ++n2 < 3 ? 100 : 1000;
                if (n5 < 0 || n5 >= n3) {
                    return 0;
                }
                n = n * n3 + n5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        while (n2 < 3) {
            int n7 = ++n2 < 3 ? 100 : 1000;
            n *= n7;
        }
        if (n2 != 3) {
            return 0;
        }
        return n;
    }

    public static interface JavaSupportImpl {
        public int getScaleFactor(@NotNull Graphics var1);

        public Image createMultiResolutionImage(int var1, int var2, @NotNull BufferedImage var3);
    }
}

