/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SliderCircularTickPainter {
    @NotNull
    protected final Color color;
    protected final double w;
    protected final double h;
    protected final double x;
    protected final double y;
    protected final double radius;
    protected final double zeroAngle;
    protected final int tickCount;
    protected final double p0;
    protected final double p1;

    public SliderCircularTickPainter(@NotNull Color color, double d, double d2, double d3, double d4, double d5, double d6, int n, double d7, double d8) {
        this.color = color;
        this.w = d;
        this.h = d2;
        this.x = d3;
        this.y = d4;
        this.radius = d5;
        this.zeroAngle = d6;
        this.tickCount = n;
        this.p0 = d7;
        this.p1 = d8;
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        if (this.tickCount == 1) {
            this.drawTick(graphics2D, this.p0);
        } else {
            double d = (this.p1 - this.p0) / (double)this.tickCount;
            double d2 = this.p0;
            for (int i = 0; i < this.tickCount; ++i) {
                this.drawTick(graphics2D, d2);
                d2 += d;
            }
        }
    }

    protected void drawTick(@NotNull Graphics2D graphics2D, double d) {
        double d2 = this.zeroAngle - d * 2.0 * Math.PI;
        double d3 = this.x + Math.cos(d2) * this.radius - this.w / 2.0;
        double d4 = this.y - Math.sin(d2) * this.radius - this.h / 2.0;
        graphics2D.setColor(this.color);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, this.w, this.h);
        graphics2D.fill(double_);
    }
}

