/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.text.DecimalFormat;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderInsets {
    @NotNull
    protected static final DecimalFormat df = new DecimalFormat("0.#");
    public final float left;
    public final float top;
    public final float widthAdjust;
    public final float heightAdjust;

    public RenderInsets(float f, float f2, float f3, float f4) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Invalid left inset");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Invalid top inset");
        }
        this.left = f;
        this.top = f2;
        this.widthAdjust = f3;
        this.heightAdjust = f4;
    }

    public RenderInsets(double d, double d2, double d3, double d4) {
        this((float)d, (float)d2, (float)d3, (float)d4);
    }

    @NotNull
    public RenderInsets scale(float f) {
        if (f == 1.0f) {
            return this;
        }
        float f2 = (float)Math.round(this.left * f) / f;
        float f3 = (float)Math.round(this.top * f) / f;
        return new RenderInsets(f2, f3, this.widthAdjust, this.heightAdjust);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RenderInsets)) {
            return false;
        }
        RenderInsets renderInsets = (RenderInsets)object;
        return Float.compare(renderInsets.left, this.left) == 0 && Float.compare(renderInsets.top, this.top) == 0 && Float.compare(renderInsets.widthAdjust, this.widthAdjust) == 0 && Float.compare(renderInsets.heightAdjust, this.heightAdjust) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.left), Float.valueOf(this.top), Float.valueOf(this.widthAdjust), Float.valueOf(this.heightAdjust));
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.left != 0.0f) {
            stringBuilder.append(" Left=");
            stringBuilder.append(df.format(this.left));
        }
        if (this.top != 0.0f) {
            stringBuilder.append(" Top=");
            stringBuilder.append(df.format(this.top));
        }
        if (this.widthAdjust != 0.0f) {
            stringBuilder.append(" W=");
            if (this.widthAdjust > 0.0f) {
                stringBuilder.append("+");
            }
            stringBuilder.append(df.format(this.widthAdjust));
        }
        if (this.heightAdjust != 0.0f) {
            stringBuilder.append(" H=");
            if (this.heightAdjust > 0.0f) {
                stringBuilder.append("+");
            }
            stringBuilder.append(df.format(this.heightAdjust));
        }
        return (string = stringBuilder.toString().trim()).isEmpty() ? "NULL" : string;
    }

    static {
        df.setDecimalSeparatorAlwaysShown(false);
    }
}

