/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.ImageUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class LinearSliderRenderer
extends Renderer {
    @NotNull
    private static final ReusableCompositor.PixelOperator blender = new Blender();
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer trackRenderer;
    @NotNull
    protected final Insetter trackInsets;
    @Nullable
    protected final Renderer tickMarkRenderer;
    @Nullable
    protected final Insetter tickMarkInsets;
    @NotNull
    protected final Renderer thumbRenderer;
    @NotNull
    protected final Insetter thumbInsets;
    protected final boolean isThumbTranslucent;
    @Nullable
    protected final ReusableCompositor.PixelOperator tickOperator;

    public LinearSliderRenderer(@NotNull SliderConfiguration sliderConfiguration, @NotNull Renderer renderer, @NotNull Insetter insetter, @Nullable Renderer renderer2, @Nullable Insetter insetter2, @NotNull Renderer renderer3, @NotNull Insetter insetter3, boolean bl, @Nullable ReusableCompositor.PixelOperator pixelOperator) {
        this.g = sliderConfiguration;
        this.trackRenderer = renderer;
        this.trackInsets = insetter;
        this.tickMarkRenderer = renderer2;
        this.tickMarkInsets = insetter2;
        this.thumbRenderer = renderer3;
        this.thumbInsets = insetter3;
        this.isThumbTranslucent = bl;
        this.tickOperator = pixelOperator;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        Object object;
        Object object2;
        float f = reusableCompositor.getWidth();
        float f2 = reusableCompositor.getHeight();
        Rectangle2D rectangle2D = this.trackInsets.apply2D(f, f2);
        Object object3 = Renderer.createOffsetRenderer(this.trackRenderer, rectangle2D);
        object3.composeTo(reusableCompositor);
        if (this.tickMarkRenderer != null && this.tickMarkInsets != null) {
            object2 = this.tickMarkInsets.apply2D(f, f2);
            object = Renderer.createOffsetRenderer(this.tickMarkRenderer, (Rectangle2D)object2);
            if (this.tickOperator != null) {
                ReusableCompositor reusableCompositor2 = reusableCompositor.createSimilar();
                object.composeTo(reusableCompositor2);
                reusableCompositor.blendFrom(reusableCompositor2, this.tickOperator);
            } else {
                object.composeTo(reusableCompositor);
            }
        }
        object3 = this.thumbInsets.apply2D(f, f2);
        object2 = Renderer.createOffsetRenderer(this.thumbRenderer, (Rectangle2D)object3);
        if (this.isThumbTranslucent) {
            object = reusableCompositor.createSimilar();
            object2.composeTo((ReusableCompositor)object);
            reusableCompositor.blendFrom((ReusableCompositor)object, blender);
        } else {
            object2.composeTo(reusableCompositor);
        }
    }

    private static class Blender
    implements ReusableCompositor.PixelOperator {
        private Blender() {
        }

        @Override
        public int combine(int n, int n2) {
            int n3 = ImageUtils.alpha(n2);
            if (n3 == 0) {
                return n;
            }
            if (n3 > 20) {
                return n2;
            }
            return JNRUtils.combine(n, n2);
        }
    }
}

