/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.GenericButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class SegmentedButtonConfiguration
extends SegmentedButtonLayoutConfiguration
implements GenericButtonConfiguration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isSelected;
    private final boolean isFocused;
    @NotNull
    private final AquaUIPainter.Direction d;
    @NotNull
    private final DividerState leftDividerState;
    @NotNull
    private final DividerState rightDividerState;
    @NotNull
    private final AquaUIPainter.SwitchTracking tracking;

    public SegmentedButtonConfiguration(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean bl, boolean bl2, @NotNull AquaUIPainter.Direction direction, @NotNull AquaUIPainter.Position position, @NotNull DividerState dividerState, @NotNull DividerState dividerState2) {
        this(segmentedButtonWidget, size, state, bl, bl2, direction, position, dividerState, dividerState2, AquaUIPainter.SwitchTracking.SELECT_ONE);
    }

    public SegmentedButtonConfiguration(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean bl, boolean bl2, @NotNull AquaUIPainter.Direction direction, @NotNull AquaUIPainter.Position position, @NotNull DividerState dividerState, @NotNull DividerState dividerState2, @NotNull AquaUIPainter.SwitchTracking switchTracking) {
        super(segmentedButtonWidget, size, position);
        if (state.isInactive() && !SegmentedButtonConfiguration.isSensitiveToInactiveState(segmentedButtonWidget)) {
            state = state.toActive();
        }
        this.state = state;
        this.isSelected = bl;
        this.isFocused = bl2;
        this.d = direction;
        this.leftDividerState = dividerState;
        this.rightDividerState = dividerState2;
        this.tracking = switchTracking;
    }

    public SegmentedButtonConfiguration(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration, @NotNull AquaUIPainter.State state, boolean bl, boolean bl2, @NotNull AquaUIPainter.Direction direction, @NotNull DividerState dividerState, @NotNull DividerState dividerState2) {
        this(segmentedButtonLayoutConfiguration.getWidget(), segmentedButtonLayoutConfiguration.getSize(), state, bl, bl2, direction, segmentedButtonLayoutConfiguration.getPosition(), dividerState, dividerState2, AquaUIPainter.SwitchTracking.SELECT_ONE);
    }

    public SegmentedButtonConfiguration(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration, @NotNull AquaUIPainter.State state, boolean bl, boolean bl2, @NotNull AquaUIPainter.Direction direction, @NotNull DividerState dividerState, @NotNull DividerState dividerState2, @NotNull AquaUIPainter.SwitchTracking switchTracking) {
        this(segmentedButtonLayoutConfiguration.getWidget(), segmentedButtonLayoutConfiguration.getSize(), state, bl, bl2, direction, segmentedButtonLayoutConfiguration.getPosition(), dividerState, dividerState2, switchTracking);
    }

    @NotNull
    public SegmentedButtonConfiguration withWidget(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        return new SegmentedButtonConfiguration(segmentedButtonWidget, this.getSize(), this.state, this.isSelected, this.isFocused, this.d, this.getPosition(), this.leftDividerState, this.rightDividerState, this.tracking);
    }

    @Override
    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    @Override
    public boolean isTextured() {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = this.getWidget();
        return segmentedButtonWidget.isTextured();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @NotNull
    public AquaUIPainter.Direction getDirection() {
        return this.d;
    }

    @NotNull
    public DividerState getLeftDividerState() {
        return this.leftDividerState;
    }

    @NotNull
    public DividerState getRightDividerState() {
        return this.rightDividerState;
    }

    @NotNull
    public AquaUIPainter.SwitchTracking getTracking() {
        return this.tracking;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SegmentedButtonConfiguration segmentedButtonConfiguration = (SegmentedButtonConfiguration)object;
        return this.state == segmentedButtonConfiguration.state && this.isSelected == segmentedButtonConfiguration.isSelected && this.isFocused == segmentedButtonConfiguration.isFocused && this.d == segmentedButtonConfiguration.d && this.leftDividerState == segmentedButtonConfiguration.leftDividerState && this.rightDividerState == segmentedButtonConfiguration.rightDividerState && this.tracking == segmentedButtonConfiguration.tracking && super.layoutEquals(segmentedButtonConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isSelected, this.isFocused, this.d, this.leftDividerState, this.rightDividerState, this.tracking});
    }

    @Override
    @NotNull
    public String toString() {
        String string;
        String string2;
        String string3 = this.isFocused ? " focused" : "";
        String string4 = string2 = this.isSelected ? "S" : "-";
        String string5 = this.leftDividerState == DividerState.NONE ? "" : (string = this.leftDividerState == DividerState.ORDINARY ? "<" : "[");
        String string6 = this.rightDividerState == DividerState.NONE ? "" : (this.rightDividerState == DividerState.ORDINARY ? ">" : "]");
        String string7 = this.tracking == AquaUIPainter.SwitchTracking.SELECT_ANY ? "SelectAny" : "SelectOne";
        return super.toString() + " " + (Object)((Object)this.d) + " " + string7 + " " + (Object)((Object)this.state) + string3 + " " + string + string2 + string6;
    }

    private static boolean isSensitiveToInactiveState(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        int n = JNRPlatformUtils.getPlatformVersion();
        if (n >= 101500 && segmentedButtonWidget.isTextured() && !segmentedButtonWidget.isToolbar()) {
            return false;
        }
        return n < 101600 || !segmentedButtonWidget.isSlider() || segmentedButtonWidget.isToolbar();
    }

    public static enum DividerState {
        NONE,
        ORDINARY,
        SELECTED;

    }
}

