/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockManager {
    private static final Lock LOCK = new ReentrantLock(true);
    private static final Map<String, LockReference> LOCK_REFERENCES = new HashMap<String, LockReference>();

    private LockManager() {
    }

    public static boolean tryLock(String key) {
        LockReference lockReference;
        LockManager.notBlank(key, "key is null", "key is blank");
        String trimmedKey = key.trim();
        LOCK.lock();
        try {
            lockReference = LOCK_REFERENCES.get(trimmedKey);
            if (lockReference == null) {
                lockReference = new LockReference();
                LOCK_REFERENCES.put(trimmedKey, lockReference);
            }
            lockReference.addThread();
        }
        finally {
            LOCK.unlock();
        }
        return lockReference.getLock().tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryLock(String key, long timeout, TimeUnit timeUnit) throws InterruptedException {
        LockReference lockReference;
        LockManager.notBlank(key, "key is null", "key is blank");
        LockManager.notNull((Object)timeUnit, "timeUnit is null");
        String trimmedKey = key.trim();
        LOCK.lock();
        try {
            lockReference = LOCK_REFERENCES.get(trimmedKey);
            if (lockReference == null) {
                lockReference = new LockReference();
                LOCK_REFERENCES.put(trimmedKey, lockReference);
            }
            lockReference.addThread();
        }
        finally {
            LOCK.unlock();
        }
        return lockReference.getLock().tryLock(timeout, timeUnit);
    }

    public static void lock(String key) {
        LockReference lockReference;
        LockManager.notBlank(key, "key is null", "key is blank");
        String trimmedKey = key.trim();
        LOCK.lock();
        try {
            lockReference = LOCK_REFERENCES.get(trimmedKey);
            if (lockReference == null) {
                lockReference = new LockReference();
                LOCK_REFERENCES.put(trimmedKey, lockReference);
            }
            lockReference.addThread();
        }
        finally {
            LOCK.unlock();
        }
        lockReference.getLock().lock();
    }

    public static void unlock(String key) {
        LockManager.notBlank(key, "key is null", "key is blank");
        String trimmedKey = key.trim();
        LOCK.lock();
        try {
            LockReference lockReference = LOCK_REFERENCES.get(trimmedKey);
            if (lockReference == null || lockReference.getThreadCount() == 0) {
                throw new IllegalMonitorStateException(String.format("Key [%s] is not locked", trimmedKey));
            }
            if (!lockReference.getLock().isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException(String.format("Current thread does not own the Lock for key [%s]", trimmedKey));
            }
            lockReference.getLock().unlock();
            lockReference.removeThread();
            if (lockReference.getThreadCount() == 0) {
                LOCK_REFERENCES.remove(trimmedKey);
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public static boolean isLocked(String key) {
        LockManager.notBlank(key, "key is null", "key is blank");
        String trimmedKey = key.trim();
        LOCK.lock();
        try {
            boolean bl = LOCK_REFERENCES.get(trimmedKey) != null;
            return bl;
        }
        finally {
            LOCK.unlock();
        }
    }

    static void assertSize(int size) {
        LOCK.lock();
        try {
            if (LOCK_REFERENCES.size() != size) {
                throw new IllegalStateException("lockReferences size is incorrect");
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void notBlank(String string, String nullMessage, String blankMessage) {
        if (string == null) {
            throw new IllegalArgumentException(nullMessage);
        }
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException(blankMessage);
        }
    }

    private static class LockReference {
        private final ReentrantLock reentrantLock = new ReentrantLock(true);
        private final Set<Thread> threads = new HashSet<Thread>();

        private LockReference() {
        }

        private ReentrantLock getLock() {
            return this.reentrantLock;
        }

        private void addThread() {
            this.threads.add(Thread.currentThread());
        }

        private void removeThread() {
            this.threads.remove(Thread.currentThread());
        }

        private int getThreadCount() {
            return this.threads.size();
        }
    }
}

