/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;

public class ShellScript {
    private ShellScript() {
    }

    private static boolean isShellAvailable(String shell) {
        String[] paths;
        String pathEnvironmentVariable = System.getenv("PATH");
        if (pathEnvironmentVariable == null || pathEnvironmentVariable.trim().isEmpty()) {
            return false;
        }
        for (String dir : paths = pathEnvironmentVariable.split(File.pathSeparator)) {
            File candidate = new File(dir, shell);
            if (!candidate.isFile() || !candidate.canExecute()) continue;
            return true;
        }
        return false;
    }

    public static Result execute(Shell shell, Path script, Consumer<String> consumer) {
        return ShellScript.execute(shell, null, script, consumer);
    }

    public static Result execute(Shell shell, Path workingDirectory, Path script, Consumer<String> consumer) {
        Path scriptPath;
        if (shell == null) {
            throw new IllegalArgumentException("shell is null");
        }
        if (!ShellScript.isShellAvailable(shell.getShell())) {
            throw new IllegalArgumentException(String.format("shell [%s] not found in system PATH", shell.getShell()));
        }
        if (script == null) {
            throw new IllegalArgumentException("script is null");
        }
        Path path = script.isAbsolute() ? script : (scriptPath = workingDirectory != null ? workingDirectory.resolve(script) : script);
        if (!Files.isRegularFile(scriptPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("script [%s] is not a file", scriptPath));
        }
        if (!Files.isReadable(scriptPath)) {
            throw new IllegalArgumentException(String.format("script [%s] is not readable", scriptPath));
        }
        if (!Files.isExecutable(scriptPath)) {
            throw new IllegalArgumentException(String.format("script [%s] is not executable", scriptPath));
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer is null");
        }
        ProcessBuilder builder = new ProcessBuilder(shell.getShell(), scriptPath.toAbsolutePath().toString());
        if (workingDirectory != null) {
            builder.directory(workingDirectory.toFile());
        } else {
            Path scriptDir = scriptPath.getParent();
            builder.directory(scriptDir != null ? scriptDir.toFile() : new File("."));
        }
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    consumer.accept(line);
                }
            }
            int exitCode = process.waitFor();
            return new Result(exitCode, null);
        }
        catch (IOException | InterruptedException e) {
            return new Result(-1, e);
        }
    }

    public static enum Shell {
        BASH("bash"),
        SH("sh"),
        ZSH("zsh"),
        KSH("ksh"),
        DASH("dash"),
        FISH("fish");

        private final String shell;

        private Shell(String shell) {
            this.shell = shell;
        }

        public String getShell() {
            return this.shell;
        }

        public String toString() {
            return this.shell;
        }
    }

    public static class Result {
        private final int exitCode;
        private final Throwable throwable;

        private Result(int exitCode, Throwable throwable) {
            this.exitCode = exitCode;
            this.throwable = throwable;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public boolean hasThrowable() {
            return this.throwable != null;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

