/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.verifyica.api.ArgumentContext;
import org.verifyica.api.ClassContext;
import org.verifyica.api.EngineContext;

public interface ClassInterceptor {
    public static final Predicate<ClassContext> ACCEPT_ALL = classContext -> true;

    default public void initialize(EngineContext engineContext) throws Throwable {
    }

    default public Predicate<ClassContext> predicate() {
        return ACCEPT_ALL;
    }

    default public void preInstantiate(EngineContext engineContext, Class<?> testClass) throws Throwable {
    }

    default public void postInstantiate(EngineContext engineContext, Class<?> testClass, Object testInstance, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void prePrepare(ClassContext classContext) throws Throwable {
    }

    default public void postPrepare(ClassContext classContext, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void preBeforeAll(ArgumentContext argumentContext) throws Throwable {
    }

    default public void postBeforeAll(ArgumentContext argumentContext, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void preBeforeEach(ArgumentContext argumentContext) throws Throwable {
    }

    default public void postBeforeEach(ArgumentContext argumentContext, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void preTest(ArgumentContext argumentContext, Method testMethod) throws Throwable {
    }

    default public void postTest(ArgumentContext argumentContext, Method testMethod, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void preAfterEach(ArgumentContext argumentContext) throws Throwable {
    }

    default public void postAfterEach(ArgumentContext argumentContext, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void preAfterAll(ArgumentContext argumentContext) throws Throwable {
    }

    default public void postAfterAll(ArgumentContext argumentContext, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void preConclude(ClassContext classContext) throws Throwable {
    }

    default public void postConclude(ClassContext classContext, Throwable throwable) throws Throwable {
        this.rethrow(throwable);
    }

    default public void onDestroy(ClassContext classContext) throws Throwable {
    }

    default public void destroy(EngineContext engineContext) throws Throwable {
    }

    default public void rethrow(Throwable throwable) throws Throwable {
        if (throwable != null) {
            throw throwable;
        }
    }
}

