/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.util;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDObject;

public class TableHelper {
    public static Long getColSpan(PDObject simplePDObject) {
        return TableHelper.getSpanValue(simplePDObject, ASAtom.COL_SPAN);
    }

    public static Long getRowSpan(PDObject simplePDObject) {
        return TableHelper.getSpanValue(simplePDObject, ASAtom.ROW_SPAN);
    }

    private static Long getSpanValue(PDObject simplePDObject, ASAtom spanName) {
        Long spanValue;
        Long defaultValue = 1L;
        COSObject aValue = simplePDObject.getKey(ASAtom.A);
        if (aValue == null) {
            return defaultValue;
        }
        if (aValue.getType() == COSObjType.COS_ARRAY) {
            for (COSObject object : (COSArray)aValue.getDirectBase()) {
                Long spanValue2 = TableHelper.getSpanValue(object, spanName);
                if (spanValue2 == null) continue;
                return spanValue2;
            }
        }
        return (spanValue = TableHelper.getSpanValue(aValue, spanName)) != null ? spanValue : defaultValue;
    }

    private static Long getSpanValue(COSObject object, ASAtom spanName) {
        if (object.getType() == COSObjType.COS_DICT && "Table".equals(object.getStringKey(ASAtom.O))) {
            return object.getIntegerKey(spanName);
        }
        return null;
    }
}

