/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.patterns;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.tools.TypeConverter;

public class PDShading
extends PDResource {
    private static final Logger LOGGER = Logger.getLogger(PDShading.class.getCanonicalName());
    private final PDResources resources;

    public PDShading(COSObject obj, PDResources resources) {
        super(obj);
        this.resources = resources;
    }

    public int getShadingType() {
        Long type = this.getObject().getIntegerKey(ASAtom.SHADING_TYPE);
        if (type != null) {
            return type.intValue();
        }
        LOGGER.log(Level.FINE, "Shading object do not contain required key ShadingType");
        return 0;
    }

    public PDColorSpace getColorSpace() {
        COSObject obj = this.getObject().getKey(ASAtom.COLORSPACE);
        if (obj != null && !obj.empty()) {
            return ColorSpaceFactory.getColorSpace(obj, this.resources, false);
        }
        LOGGER.log(Level.FINE, "Shading object do not contain required key ColorSpace");
        return null;
    }

    public double[] getBBox() {
        return TypeConverter.getRealArray(this.getKey(ASAtom.BBOX), 4, "BBox");
    }

    public boolean getAntiAlias() {
        Boolean antiAlias = this.getObject().getBooleanKey(ASAtom.ANTI_ALIAS);
        return antiAlias == null ? false : antiAlias;
    }
}

