/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.util.Arrays;

public class CFFIndex {
    private int count;
    private int offsetShift;
    private int[] offsets;
    private byte[] data;

    CFFIndex(int count, int offsetShift, int[] offsets, byte[] data) {
        this.count = count;
        this.offsetShift = offsetShift;
        this.offsets = offsets;
        this.data = data;
    }

    int size() {
        return this.count;
    }

    byte[] get(int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException("Can't get object with number " + n + " from INDEX with " + this.count + " elements.");
        }
        return Arrays.copyOfRange(this.data, this.offsets[n] - 1, this.offsets[n + 1] - 1);
    }

    int getOffset(int i) {
        return this.offsets[i];
    }

    int getOffsetShift() {
        return this.offsetShift;
    }

    int getDataLength() {
        return this.data.length;
    }

    public static CFFIndex getEmptyIndex() {
        return new CFFIndex(0, 0, new int[0], new byte[0]);
    }
}

