/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Logger;

public class ToUnicodeInterval {
    private static final Logger LOGGER = Logger.getLogger(ToUnicodeInterval.class.getCanonicalName());
    private long intervalBegin;
    private long intervalEnd;
    private byte[] startingValue;

    public ToUnicodeInterval(long intervalBegin, long intervalEnd, byte[] startingValue) {
        this.intervalBegin = intervalBegin;
        this.intervalEnd = intervalEnd;
        this.startingValue = startingValue;
    }

    public boolean containsCode(long code) {
        return code >= this.intervalBegin && code <= this.intervalEnd;
    }

    public String toUnicode(int code) {
        byte[] unicode = Arrays.copyOf(this.startingValue, this.startingValue.length);
        unicode[unicode.length - 1] = (byte)((long)code - this.intervalBegin + (long)this.startingValue[this.startingValue.length - 1]);
        return ToUnicodeInterval.getUnicodeNameFromLong(unicode);
    }

    private static String getUnicodeNameFromLong(byte[] unicode) {
        String fffe = ToUnicodeInterval.getFFFEFromUnicode(unicode);
        if (fffe == null) {
            fffe = ToUnicodeInterval.getFEFFFromUnicode(unicode);
        }
        if (fffe != null) {
            return fffe;
        }
        return unicode[0] == 0 ? String.valueOf(unicode[1]) : new String(unicode, StandardCharsets.UTF_16BE);
    }

    private static String getFFFEFromUnicode(byte[] unicode) {
        for (int i = 0; i < unicode.length - 1; ++i) {
            if (unicode[i] != -1 || unicode[i + 1] != -2) continue;
            char[] c = new char[]{'\ufffe'};
            return new String(c);
        }
        return null;
    }

    private static String getFEFFFromUnicode(byte[] unicode) {
        for (int i = 0; i < unicode.length - 1; ++i) {
            if (unicode[i] != -2 || unicode[i + 1] != -1) continue;
            char[] c = new char[]{'\ufffe'};
            return new String(c);
        }
        return null;
    }
}

