/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.cmap.PDCMap;
import org.verapdf.pd.font.type3.PDType3Font;

public abstract class PDFont
extends PDResource {
    private static final Logger LOGGER = Logger.getLogger(PDFont.class.getCanonicalName());
    protected COSDictionary dictionary;
    protected PDFontDescriptor fontDescriptor;
    protected PDCMap toUnicodeCMap;
    protected boolean isFontParsed = false;
    protected FontProgram fontProgram;
    protected Encoding encoding = null;
    private boolean successfullyParsed = false;
    private final String fontName;
    private final ASAtom subtype;

    public PDFont(COSDictionary dictionary) {
        super(new COSObject(dictionary));
        if (dictionary == null) {
            dictionary = (COSDictionary)COSDictionary.construct().get();
        }
        this.dictionary = dictionary;
        COSObject fd = dictionary.getKey(ASAtom.FONT_DESC);
        this.fontDescriptor = fd != null && fd.getType() == COSObjType.COS_DICT ? new PDFontDescriptor(fd) : new PDFontDescriptor(COSDictionary.construct());
        this.fontName = this.dictionary.getStringKey(ASAtom.BASE_FONT);
        this.subtype = this.dictionary.getNameKey(ASAtom.SUBTYPE);
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    public String getType() {
        String type = this.dictionary.getStringKey(ASAtom.TYPE);
        return type == null ? "" : type;
    }

    public ASAtom getSubtype() {
        return this.subtype;
    }

    public boolean isSymbolic() {
        return this.fontDescriptor.isSymbolic();
    }

    public Encoding getEncodingMapping() {
        if (this.encoding == null) {
            this.encoding = PDFont.getEncodingMappingFromCOSObject(this.getEncoding());
        }
        return this.encoding;
    }

    private static Encoding getEncodingMappingFromCOSObject(COSObject e) {
        COSBase cosEncoding = e.getDirectBase();
        if (cosEncoding != null) {
            if (cosEncoding.getType() == COSObjType.COS_NAME) {
                Encoding encodingObj = new Encoding(cosEncoding.getName());
                return encodingObj;
            }
            if (cosEncoding.getType() == COSObjType.COS_DICT) {
                Encoding encodingObj = new Encoding(cosEncoding.getNameKey(ASAtom.BASE_ENCODING), PDFont.getDifferencesFromCosEncoding(e));
                return encodingObj;
            }
        }
        return Encoding.empty();
    }

    public String getName() {
        return this.fontName;
    }

    public COSObject getEncoding() {
        return this.dictionary.getKey(ASAtom.ENCODING);
    }

    public Map<Integer, String> getDifferences() {
        return PDFont.getDifferencesFromCosEncoding(this.getEncoding());
    }

    public static Map<Integer, String> getDifferencesFromCosEncoding(COSObject e) {
        COSArray differences;
        COSObject cosDifferences = e.getKey(ASAtom.DIFFERENCES);
        if (cosDifferences == null) {
            return Collections.emptyMap();
        }
        if (cosDifferences.getType() == COSObjType.COS_ARRAY) {
            differences = (COSArray)cosDifferences.getDirectBase();
        } else {
            if (!cosDifferences.empty()) {
                LOGGER.log(Level.SEVERE, "Value of Differences key is not an array. Ignoring Difference");
            }
            differences = null;
        }
        if (differences == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, String> res = new HashMap<Integer, String>();
        int diffIndex = 0;
        for (COSObject obj : differences) {
            if (obj.getType() == COSObjType.COS_INTEGER) {
                diffIndex = obj.getInteger().intValue();
                continue;
            }
            if (obj.getType() != COSObjType.COS_NAME || diffIndex == -1) continue;
            res.put(diffIndex++, obj.getString());
        }
        return res;
    }

    public COSObject getWidths() {
        return this.dictionary.getKey(ASAtom.WIDTHS);
    }

    public Long getFirstChar() {
        return this.dictionary.getIntegerKey(ASAtom.FIRST_CHAR);
    }

    public Long getLastChar() {
        return this.dictionary.getIntegerKey(ASAtom.LAST_CHAR);
    }

    public int readCode(InputStream stream) throws IOException {
        return stream.read();
    }

    public abstract FontProgram getFontProgram();

    public abstract float getWidthFromProgram(int var1);

    public abstract boolean glyphIsPresent(int var1);

    public String toUnicode(int code) {
        return this.cMapToUnicode(code);
    }

    public String cMapToUnicode(int code) {
        if (this.toUnicodeCMap == null) {
            this.toUnicodeCMap = new PDCMap(this.dictionary.getKey(ASAtom.TO_UNICODE));
        }
        if (this.toUnicodeCMap.getCMapName() != null && this.toUnicodeCMap.isIdentity()) {
            return new String(new char[]{(char)code});
        }
        return this.toUnicodeCMap.toUnicode(code);
    }

    public ASAtom getProgramSubtype() {
        COSStream fontFile = this.fontDescriptor.getFontFile();
        if (fontFile == null && (fontFile = this.fontDescriptor.getFontFile2()) == null) {
            fontFile = this.fontDescriptor.getFontFile3();
        }
        return fontFile == null ? null : fontFile.getNameKey(ASAtom.SUBTYPE);
    }

    public Double getWidth(int code) {
        if (this.dictionary.knownKey(ASAtom.WIDTHS).booleanValue() && this.dictionary.knownKey(ASAtom.FIRST_CHAR).booleanValue() && this.dictionary.knownKey(ASAtom.LAST_CHAR).booleanValue()) {
            int firstChar = this.dictionary.getIntegerKey(ASAtom.FIRST_CHAR).intValue();
            int lastChar = this.dictionary.getIntegerKey(ASAtom.LAST_CHAR).intValue();
            if (this.getWidths().size() > 0 && code >= firstChar && code <= lastChar) {
                return this.getWidths().at(code - firstChar).getReal();
            }
        }
        if (this.fontDescriptor.knownKey(ASAtom.MISSING_WIDTH)) {
            return this.fontDescriptor.getMissingWidth();
        }
        if (this instanceof PDType3Font) {
            return null;
        }
        return 0.0;
    }

    public Double getDefaultWidth() {
        return this.fontDescriptor.getMissingWidth();
    }

    public boolean isSuccessfullyParsed() {
        return this.successfullyParsed;
    }

    public void setSuccessfullyParsed(boolean successfullyParsed) {
        this.successfullyParsed = successfullyParsed;
    }

    protected boolean isSubset() {
        String[] nameSplitting = this.getName().split("\\+");
        return nameSplitting[0].length() == 6;
    }
}

