/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSStream;
import org.verapdf.external.ICCProfile;
import org.verapdf.features.gf.tools.GFAdapterHelper;
import org.verapdf.features.objects.ICCProfileFeaturesObjectAdapter;
import org.verapdf.pd.PDMetadata;

public class GFICCProfileFeaturesObjectAdapter
implements ICCProfileFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(GFICCProfileFeaturesObjectAdapter.class.getCanonicalName());
    private static final int HEADER_SIZE = 128;
    private static final int FF_FLAG = 255;
    private static final int REQUIRED_LENGTH = 4;
    private static final int VERSION_BYTE = 8;
    private static final int SUBVERSION_BYTE = 9;
    private final ICCProfile profile;
    private final String id;
    private String version;
    private String cmmType;
    private String dataColorSpace;
    private String creator;
    private Calendar creationDate;
    private String defaultRenderingIntent;
    private String copyright;
    private String description;
    private String profileID;
    private String deviceModel;
    private String deviceManufacturer;
    private List<String> errors;

    public GFICCProfileFeaturesObjectAdapter(ICCProfile profile, String id) {
        this.profile = profile;
        this.id = id;
        this.init();
    }

    private void init() {
        if (this.profile != null && !this.profile.empty()) {
            try (ASInputStream iccData = this.profile.getObject().getData(COSStream.FilterFlags.DECODE);){
                this.errors = new ArrayList<String>();
                byte[] profileBytes = GFAdapterHelper.inputStreamToByteArray((InputStream)iccData);
                if (profileBytes.length < 128) {
                    this.errors.add("ICCProfile contains less than 128 bytes");
                } else {
                    this.version = GFICCProfileFeaturesObjectAdapter.getVersion(profileBytes);
                    this.cmmType = this.profile.getCMMType();
                    this.dataColorSpace = this.profile.getColorSpace();
                    this.creator = this.profile.getCreator();
                    this.creationDate = this.profile.getCreationDate();
                    this.defaultRenderingIntent = this.profile.getRenderingIntent();
                    this.copyright = this.profile.getCopyright();
                    this.description = this.profile.getDescription();
                    this.profileID = this.profile.getProfileID();
                    this.deviceModel = this.profile.getDeviceModel();
                    this.deviceManufacturer = this.profile.getDeviceManufacturer();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Reading byte array from InputStream error", e);
                this.errors.add(e.getMessage());
            }
        }
    }

    private static String getVersion(byte[] header) {
        if (header[8] == 0 && header[9] == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(header[8] & 0xFF).append('.');
        builder.append((header[9] & 0xFF) >>> 4);
        return builder.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCMMType() {
        return this.cmmType;
    }

    public String getDataColorSpace() {
        return this.dataColorSpace;
    }

    public String getCreator() {
        return this.creator;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getDefaultRenderingIntent() {
        return this.defaultRenderingIntent;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public boolean isPDFObjectPresent() {
        return this.profile != null && !this.profile.empty();
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    public InputStream getMetadataStream() {
        PDMetadata meta;
        if (this.profile != null && !this.profile.empty() && (meta = this.profile.getMetadata()) != null) {
            return meta.getStream();
        }
        return null;
    }

    public InputStream getData() {
        if (this.profile != null && !this.profile.empty()) {
            return this.profile.getObject().getData(COSStream.FilterFlags.DECODE);
        }
        return null;
    }

    public Integer getN() {
        if (this.profile != null && !this.profile.empty()) {
            Long n = this.profile.getNumberOfColorants();
            return n == null ? null : Integer.valueOf(n.intValue());
        }
        return null;
    }

    public List<Double> getRange() {
        if (this.profile != null && !this.profile.empty()) {
            ArrayList<Double> range = new ArrayList<Double>();
            double[] profileRange = this.profile.getRange();
            if (profileRange != null) {
                for (double value : profileRange) {
                    range.add(value);
                }
            } else {
                Integer n = this.getN();
                if (n != null) {
                    for (int i = 0; i < n; ++i) {
                        range.add(0.0);
                        range.add(1.0);
                    }
                }
            }
            return Collections.unmodifiableList(range);
        }
        return Collections.emptyList();
    }
}

