/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.objects.EmbeddedFileFeaturesObjectAdapter;
import org.verapdf.tools.TypeConverter;

public class GFEmbeddedFileFeaturesObjectAdapter
implements EmbeddedFileFeaturesObjectAdapter {
    private final COSObject embFile;
    private Params params;
    private final COSObject cosEmbFile;
    private final int index;

    public GFEmbeddedFileFeaturesObjectAdapter(COSObject embFile, int index) {
        COSObject paramsObj;
        this.embFile = embFile;
        this.index = index;
        this.cosEmbFile = this.getEmbeddedFile();
        if (this.cosEmbFile != null && (paramsObj = this.cosEmbFile.getKey(ASAtom.PARAMS)) != null && !paramsObj.empty()) {
            this.params = new Params(paramsObj);
        }
    }

    private COSObject getEmbeddedFile() {
        COSObject file;
        COSObject efDict;
        if (this.embFile != null && !this.embFile.empty() && (efDict = this.embFile.getKey(ASAtom.EF)) != null && efDict.getType() == COSObjType.COS_DICT && (file = efDict.getKey(ASAtom.F)) != null && file.getType() == COSObjType.COS_STREAM) {
            return file;
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFileName() {
        if (this.embFile != null && this.embFile.getType().isDictionaryBased()) {
            String filename = this.embFile.getStringKey(ASAtom.UF);
            if (filename == null) {
                filename = this.embFile.getStringKey(ASAtom.DOS);
            }
            if (filename == null) {
                filename = this.embFile.getStringKey(ASAtom.MAC);
            }
            if (filename == null) {
                filename = this.embFile.getStringKey(ASAtom.UNIX);
            }
            if (filename == null) {
                filename = this.embFile.getStringKey(ASAtom.F);
            }
            return filename;
        }
        return null;
    }

    public String getDescription() {
        if (this.embFile != null && this.embFile.getType().isDictionaryBased()) {
            return this.embFile.getStringKey(ASAtom.DESC);
        }
        return null;
    }

    public String getAFRelationship() {
        if (this.embFile != null && this.embFile.getType().isDictionaryBased()) {
            return this.embFile.getNameKeyStringValue(ASAtom.AF_RELATIONSHIP);
        }
        return null;
    }

    public String getSubtype() {
        if (this.cosEmbFile != null && this.cosEmbFile.getType().isDictionaryBased()) {
            return this.cosEmbFile.getNameKeyStringValue(ASAtom.SUBTYPE);
        }
        return null;
    }

    public String getFilter() {
        COSObject filter;
        if (this.cosEmbFile != null && this.cosEmbFile.getType().isDictionaryBased() && (filter = this.cosEmbFile.getKey(ASAtom.FILTER)) != null && !filter.empty()) {
            if (filter.getType() == COSObjType.COS_NAME) {
                return filter.getString();
            }
            if (filter.getType() == COSObjType.COS_ARRAY) {
                StringBuilder builder = new StringBuilder();
                for (COSObject elem : (COSArray)filter.getDirectBase()) {
                    String elemValue = elem.getString();
                    if (elemValue == null) continue;
                    builder.append(elemValue).append(' ');
                }
                return builder.toString().trim();
            }
        }
        return null;
    }

    public Calendar getCreationDate() {
        return this.params == null ? null : this.params.getCreationDate();
    }

    public Calendar getModDate() {
        return this.params == null ? null : this.params.getModDate();
    }

    public String getCheckSum() {
        return this.params == null ? null : this.params.getCheckSum();
    }

    public Long getSize() {
        return this.params == null ? null : this.params.getSize();
    }

    public InputStream getData() {
        return this.cosEmbFile == null || this.cosEmbFile.empty() ? null : this.cosEmbFile.getData(COSStream.FilterFlags.DECODE);
    }

    public boolean isPDFObjectPresent() {
        return this.embFile != null && !this.embFile.empty();
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private static class Params {
        private final COSObject obj;

        public Params(COSObject obj) {
            this.obj = obj;
        }

        public Calendar getCreationDate() {
            return this.getDate(ASAtom.CREATION_DATE);
        }

        public Calendar getModDate() {
            return this.getDate(ASAtom.MOD_DATE);
        }

        public String getCheckSum() {
            return this.obj.getStringKey(ASAtom.CHECKSUM);
        }

        public Long getSize() {
            return this.obj.getIntegerKey(ASAtom.SIZE);
        }

        private Calendar getDate(ASAtom type) {
            String date = this.obj.getStringKey(type);
            if (date != null) {
                return TypeConverter.parseDate((String)date);
            }
            return null;
        }
    }
}

