/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridhelpers;

import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

class EnhancedSelectionGridHelper<T>
implements Serializable {
    private static final String KEY_UP_EVENT_SHIFT_KEY = "event.shiftKey";
    private static final String KEY_UP_EVENT_ALT_KEY = "event.altKey";
    private static final String KEY_UP_EVENT_CTRL_KEY = "event.ctrlKey";
    private static final String KEY_UP_EVENT_META_KEY = "event.metaKey";
    private static final String KEY_UP_ELEMENT_FOCUSED_ITEM_INDEX = "element._focusedItemIndex";
    private static final String KEY_UP_EVENT_KEY = "event.key";
    private static final String LAST_FOCUSED_ITEM = "lastFocusedItem";
    private static final String SPACEBAR_KEY = " ";
    private final GridHelper<T> helper;
    private Registration itemClickRegistration;
    private Registration keyUpRegistration;

    void enableEnhancedSelection() {
        this.disableEnhancedSelection();
        this.clearTextSelection();
        Grid grid = this.helper.getGrid();
        grid.getStyle().set("user-select", "none");
        this.itemClickRegistration = grid.addItemClickListener((ComponentEventListener & Serializable)ev -> {
            boolean isSpecialKey = ev.isCtrlKey() || ev.isMetaKey() || ev.isAltKey();
            Object clickedItem = ev.getItem();
            Object lastClickedItem = ComponentUtil.getData((Component)grid, (String)LAST_FOCUSED_ITEM);
            if (ev.isShiftKey()) {
                grid.asMultiSelect().clear();
                if (lastClickedItem != null) {
                    GridListDataView dataView = grid.getListDataView();
                    int index1 = dataView.getItems().collect(Collectors.toList()).indexOf(lastClickedItem);
                    int index2 = dataView.getItems().collect(Collectors.toList()).indexOf(clickedItem);
                    IntStream.rangeClosed(Math.min(index1, index2), Math.max(index1, index2)).forEach(i -> grid.select(dataView.getItem(i)));
                    return;
                }
            } else if (isSpecialKey && !GridHelper.isSelectOnClick(grid)) {
                if (grid.asMultiSelect().isSelected(clickedItem)) {
                    grid.deselect(clickedItem);
                } else {
                    grid.select(clickedItem);
                }
            } else if (!GridHelper.isSelectOnClick(grid)) {
                grid.asMultiSelect().clear();
                grid.select(clickedItem);
            }
            ComponentUtil.setData((Component)grid, (String)LAST_FOCUSED_ITEM, (Object)clickedItem);
        });
        this.keyUpRegistration = grid.getElement().addEventListener("keyup", (DomEventListener & Serializable)ev -> {
            String keyUp = ev.getEventData().getString(KEY_UP_EVENT_KEY);
            boolean arrowsKey = "ArrowDown".equals(keyUp) || "ArrowUp".equals(keyUp);
            GridListDataView dataView = grid.getListDataView();
            Optional newFocusedItemMaybe = Optional.empty();
            int newFocusedItemIndex = (int)ev.getEventData().getNumber(KEY_UP_ELEMENT_FOCUSED_ITEM_INDEX);
            if (newFocusedItemIndex >= 0) {
                newFocusedItemMaybe = dataView.getItems().skip(newFocusedItemIndex).findFirst();
            }
            if (newFocusedItemMaybe.isPresent()) {
                Object newFocusedItem = newFocusedItemMaybe.get();
                boolean isSpecialKey = ev.getEventData().getBoolean(KEY_UP_EVENT_META_KEY) || ev.getEventData().getBoolean(KEY_UP_EVENT_CTRL_KEY) || ev.getEventData().getBoolean(KEY_UP_EVENT_ALT_KEY);
                Object lastFocusedItem = ComponentUtil.getData((Component)grid, (String)LAST_FOCUSED_ITEM);
                boolean shiftKey = ev.getEventData().getBoolean(KEY_UP_EVENT_SHIFT_KEY);
                if (shiftKey) {
                    if (lastFocusedItem == null) {
                        ComponentUtil.setData((Component)grid, (String)LAST_FOCUSED_ITEM, newFocusedItem);
                    }
                    if (arrowsKey) {
                        grid.asMultiSelect().clear();
                        int lastFocusedItemIndex = dataView.getItems().collect(Collectors.toList()).indexOf(lastFocusedItem);
                        IntStream.rangeClosed(Math.min(lastFocusedItemIndex, newFocusedItemIndex), Math.max(lastFocusedItemIndex, newFocusedItemIndex)).forEach(i -> grid.select(dataView.getItem(i)));
                        return;
                    }
                } else if (arrowsKey && !isSpecialKey) {
                    grid.asMultiSelect().clear();
                    grid.select(newFocusedItem);
                    ComponentUtil.setData((Component)grid, (String)LAST_FOCUSED_ITEM, newFocusedItem);
                } else if (isSpecialKey && SPACEBAR_KEY.equals(keyUp)) {
                    boolean isItemSelected = grid.asMultiSelect().isSelected(newFocusedItem);
                    if (isItemSelected) {
                        grid.deselect(newFocusedItem);
                    } else {
                        grid.select(newFocusedItem);
                    }
                    ComponentUtil.setData((Component)grid, (String)LAST_FOCUSED_ITEM, newFocusedItem);
                }
            }
        }).addEventData(KEY_UP_EVENT_META_KEY).addEventData(KEY_UP_EVENT_CTRL_KEY).addEventData(KEY_UP_EVENT_SHIFT_KEY).addEventData(KEY_UP_EVENT_ALT_KEY).addEventData(KEY_UP_EVENT_KEY).addEventData(KEY_UP_ELEMENT_FOCUSED_ITEM_INDEX);
    }

    void disableEnhancedSelection() {
        if (this.itemClickRegistration != null) {
            this.itemClickRegistration.remove();
            this.itemClickRegistration = null;
        }
        if (this.keyUpRegistration != null) {
            this.keyUpRegistration.remove();
            this.keyUpRegistration = null;
        }
        this.helper.getGrid().getStyle().set("user-select", "auto");
    }

    boolean isEnhancedSelectionEnabled() {
        return this.itemClickRegistration != null && this.keyUpRegistration != null;
    }

    private void clearTextSelection() {
        UI.getCurrent().getPage().executeJs("const sel = window.getSelection ? window.getSelection() : document.selection;  if (sel) {    if (sel.removeAllRanges) {      sel.removeAllRanges();    } else if (sel.empty) {      sel.empty();    }  }", new Serializable[0]);
    }

    @Generated
    public EnhancedSelectionGridHelper(GridHelper<T> helper) {
        this.helper = helper;
    }
}

