/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.spring.profile;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.spring.annotation.ConfigureProfile;
import org.unitils.spring.annotation.SpringApplicationContext;
import org.unitils.spring.profile.TypeConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileModule
implements Module {
    private static final Log LOGGER = LogFactory.getLog(ProfileModule.class);
    private GenericApplicationContext ctx;

    public void init(Properties configuration) {
    }

    public void afterInit() {
    }

    protected void getProfile(Class<?> testClass) {
        if (this.checkIfEverythingIsInPlace(testClass)) {
            ConfigureProfile profile = testClass.getAnnotation(ConfigureProfile.class);
            if (profile.configuration().equals((Object)TypeConfiguration.CONFIGURATION)) {
                AnnotationConfigApplicationContext temp = new AnnotationConfigApplicationContext();
                this.ctx = temp;
                this.setConfigurationAsTypeConfiguration(temp, profile);
            } else {
                GenericXmlApplicationContext temp = new GenericXmlApplicationContext();
                this.ctx = temp;
                this.setConfigurationAsTypeSpringApplicationContext(temp, profile, testClass.getAnnotation(SpringApplicationContext.class).value());
            }
        }
    }

    protected void setConfigurationAsTypeConfiguration(AnnotationConfigApplicationContext ctx, ConfigureProfile profile) {
        ctx.getEnvironment().setActiveProfiles(new String[]{profile.value()});
        ctx.scan(new String[]{profile.packageProfile()});
        ctx.refresh();
    }

    protected void setConfigurationAsTypeSpringApplicationContext(GenericXmlApplicationContext ctx, ConfigureProfile profile, String[] placeContext) {
        ConfigurableEnvironment env = ctx.getEnvironment();
        env.setActiveProfiles(new String[]{profile.value()});
        ctx.load(placeContext);
        ctx.refresh();
    }

    public boolean injectBeans(Object testObject) {
        boolean everythingOk = true;
        for (Field field : testObject.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Autowired.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(testObject, this.ctx.getBean(field.getName()));
            }
            catch (BeansException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                everythingOk = false;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                everythingOk = false;
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                everythingOk = false;
            }
        }
        return everythingOk;
    }

    protected boolean checkIfEverythingIsInPlace(Class<?> testClass) {
        if (!testClass.isAnnotationPresent(ConfigureProfile.class)) {
            LOGGER.warn((Object)"The annotation 'ConfigureProfile' is not present.");
            return false;
        }
        ConfigureProfile configProfile = testClass.getAnnotation(ConfigureProfile.class);
        if (StringUtils.isEmpty((String)configProfile.value())) {
            throw new UnitilsException("The name of the profile should be filled in.");
        }
        if (configProfile.configuration().equals((Object)TypeConfiguration.APPLICATIONCONTEXT)) {
            if (!testClass.isAnnotationPresent(SpringApplicationContext.class)) {
                throw new UnitilsException("The annotation 'SpringApplicationContext' is not present.");
            }
        } else if (StringUtils.isEmpty((String)configProfile.packageProfile())) {
            throw new UnitilsException("You should fill in the name of the package of the profile.");
        }
        return true;
    }

    protected void setCtx(GenericApplicationContext ctx) {
        this.ctx = ctx;
    }

    protected GenericApplicationContext getCtx() {
        return this.ctx;
    }

    protected void closeContext() {
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    public TestListener getTestListener() {
        return new TestListener(){

            public void beforeTestClass(Class<?> testClass) {
                ProfileModule.this.getProfile(testClass);
            }

            public void beforeTestMethod(Object testObject, Method testMethod) {
                ProfileModule.this.injectBeans(testObject);
            }

            public void afterTestTearDown(Object testObject, Method testMethod) {
                ProfileModule.this.closeContext();
            }
        };
    }
}

