/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.spring.util;

import java.util.Arrays;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.AnnotatedInstanceManager;
import org.unitils.spring.annotation.SpringApplicationContext;
import org.unitils.spring.util.ApplicationContextFactory;

public class ApplicationContextManager
extends AnnotatedInstanceManager<ApplicationContext, SpringApplicationContext> {
    protected ApplicationContextFactory applicationContextFactory;

    public ApplicationContextManager(ApplicationContextFactory applicationContextFactory) {
        super(ApplicationContext.class, SpringApplicationContext.class);
        this.applicationContextFactory = applicationContextFactory;
    }

    public ApplicationContext getApplicationContext(Object testObject) {
        ApplicationContext applicationContext = (ApplicationContext)this.getInstance(testObject);
        if (applicationContext == null) {
            throw new UnitilsException("No configuration found for creating an ApplicationContext for test " + testObject.getClass() + ". Make sure that you either specify a value " + "for an @" + this.annotationClass.getSimpleName() + " annotation somewhere in the testclass or a superclass or that you specify a custom create method in the test class itself.");
        }
        return applicationContext;
    }

    public boolean hasApplicationContext(Object testObject) {
        return this.hasInstance(testObject);
    }

    public void invalidateApplicationContext(Class<?> ... classes) {
        this.invalidateInstance(classes);
    }

    protected ApplicationContext createInstanceForValues(Object testObject, Class<?> testClass, List<String> locations) {
        try {
            ConfigurableApplicationContext applicationContext = this.applicationContextFactory.createApplicationContext(locations);
            applicationContext.refresh();
            return applicationContext;
        }
        catch (Throwable t) {
            throw new UnitilsException("Unable to create application context for locations " + locations, t);
        }
    }

    protected List<String> getAnnotationValues(SpringApplicationContext annotation) {
        String[] locations = annotation.value();
        return Arrays.asList(locations);
    }
}

