/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.spring;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.database.DatabaseModule;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.spring.annotation.SpringApplicationContext;
import org.unitils.spring.annotation.SpringBean;
import org.unitils.spring.annotation.SpringBeanByName;
import org.unitils.spring.annotation.SpringBeanByType;
import org.unitils.spring.util.ApplicationContextFactory;
import org.unitils.spring.util.ApplicationContextManager;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringModule
implements Module {
    public static final String PROPKEY_APPLICATION_CONTEXT_FACTORY_CLASS_NAME = "SpringModule.applicationContextFactory.implClassName";
    private ApplicationContextManager applicationContextManager;

    public void init(Properties configuration) {
        ApplicationContextFactory applicationContextFactory = (ApplicationContextFactory)PropertyUtils.getInstance((String)PROPKEY_APPLICATION_CONTEXT_FACTORY_CLASS_NAME, (Properties)configuration);
        this.applicationContextManager = new ApplicationContextManager(applicationContextFactory);
    }

    public void afterInit() {
        if (this.isDatabaseModuleEnabled()) {
            this.getDatabaseModule().registerTransactionManagementConfiguration(new UnitilsTransactionManagementConfiguration(){

                public boolean isApplicableFor(Object testObject) {
                    if (!SpringModule.this.isApplicationContextConfiguredFor(testObject)) {
                        return false;
                    }
                    ApplicationContext context = SpringModule.this.getApplicationContext(testObject);
                    return context.getBeansOfType(this.getPlatformTransactionManagerClass()).size() != 0;
                }

                public PlatformTransactionManager getSpringPlatformTransactionManager(Object testObject) {
                    Class<?> platformTransactionManagerClass;
                    ApplicationContext context = SpringModule.this.getApplicationContext(testObject);
                    Map platformTransactionManagers = context.getBeansOfType(platformTransactionManagerClass = this.getPlatformTransactionManagerClass());
                    if (platformTransactionManagers.size() == 0) {
                        throw new UnitilsException("Could not find a bean of type " + platformTransactionManagerClass.getSimpleName() + " in the spring ApplicationContext for this class");
                    }
                    if (platformTransactionManagers.size() > 1) {
                        throw new UnitilsException("Found more than one bean of type " + platformTransactionManagerClass.getSimpleName() + " in the spring ApplicationContext for this class");
                    }
                    return (PlatformTransactionManager)platformTransactionManagers.values().iterator().next();
                }

                public boolean isTransactionalResourceAvailable(Object testObject) {
                    return true;
                }

                public Integer getPreference() {
                    return 20;
                }

                protected Class<?> getPlatformTransactionManagerClass() {
                    return ReflectionUtils.getClassWithName((String)"org.springframework.transaction.PlatformTransactionManager");
                }
            });
        }
    }

    public Object getSpringBean(Object testObject, String name) {
        try {
            return this.getApplicationContext(testObject).getBean(name);
        }
        catch (BeansException e) {
            throw new UnitilsException("Unable to get Spring bean. No Spring bean found for name " + name);
        }
    }

    public <T> T getSpringBeanByType(Object testObject, Class<T> type) {
        Map beans = this.getApplicationContext(testObject).getBeansOfType(type);
        if (beans == null || beans.size() == 0) {
            throw new UnitilsException("Unable to get Spring bean by type. No Spring bean found for type " + type.getSimpleName());
        }
        if (beans.size() > 1) {
            throw new UnitilsException("Unable to get Spring bean by type. More than one possible Spring bean for type " + type.getSimpleName() + ". Possible beans; " + beans);
        }
        return (T)beans.values().iterator().next();
    }

    public boolean isApplicationContextConfiguredFor(Object testObject) {
        return this.applicationContextManager.hasApplicationContext(testObject);
    }

    public ApplicationContext getApplicationContext(Object testObject) {
        return this.applicationContextManager.getApplicationContext(testObject);
    }

    public void invalidateApplicationContext(Class<?> ... classes) {
        this.applicationContextManager.invalidateApplicationContext(classes);
    }

    public void injectApplicationContext(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), SpringApplicationContext.class);
        for (Field field : fields) {
            try {
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.getApplicationContext(testObject));
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the application context to field annotated with @" + SpringApplicationContext.class.getSimpleName(), (Throwable)e);
            }
        }
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), SpringApplicationContext.class, (boolean)false);
        for (Method method : methods) {
            if (method.getReturnType() != Void.TYPE) continue;
            try {
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{this.getApplicationContext(testObject)});
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to assign the application context to setter annotated with @" + SpringApplicationContext.class.getSimpleName(), (Throwable)e);
            }
        }
    }

    public void injectSpringBeans(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), SpringBean.class);
        for (Field field : fields) {
            try {
                SpringBean springBeanAnnotation = field.getAnnotation(SpringBean.class);
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.getSpringBean(testObject, springBeanAnnotation.value()));
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to field annotated with @" + SpringBean.class.getSimpleName(), (Throwable)e);
            }
        }
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), SpringBean.class);
        for (Method method : methods) {
            try {
                if (!ReflectionUtils.isSetter((Method)method)) {
                    throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBean.class.getSimpleName() + ". Method " + method.getName() + " is not a setter method.");
                }
                SpringBean springBeanAnnotation = method.getAnnotation(SpringBean.class);
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{this.getSpringBean(testObject, springBeanAnnotation.value())});
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBean.class.getSimpleName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBean.class.getSimpleName() + ". Method " + "has thrown an exception.", e.getCause());
            }
        }
    }

    public void injectSpringBeansByType(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), SpringBeanByType.class);
        for (Field field : fields) {
            try {
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, this.getSpringBeanByType(testObject, field.getType()));
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to field annotated with @" + SpringBeanByType.class.getSimpleName(), (Throwable)e);
            }
        }
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), SpringBeanByType.class);
        for (Method method : methods) {
            try {
                if (!ReflectionUtils.isSetter((Method)method)) {
                    throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBeanByType.class.getSimpleName() + ". Method " + method.getName() + " is not a setter method.");
                }
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{this.getSpringBeanByType(testObject, method.getParameterTypes()[0])});
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBeanByType.class.getSimpleName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBeanByType.class.getSimpleName() + ". Method " + "has thrown an exception.", e.getCause());
            }
        }
    }

    public void injectSpringBeansByName(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), SpringBeanByName.class);
        for (Field field : fields) {
            try {
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.getSpringBean(testObject, field.getName()));
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to field annotated with @" + SpringBeanByName.class.getSimpleName(), (Throwable)e);
            }
        }
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), SpringBeanByName.class);
        for (Method method : methods) {
            try {
                if (!ReflectionUtils.isSetter((Method)method)) {
                    throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBeanByName.class.getSimpleName() + ". Method " + method.getName() + " is not a setter method.");
                }
                ReflectionUtils.invokeMethod((Object)testObject, (Method)method, (Object[])new Object[]{this.getSpringBean(testObject, ReflectionUtils.getPropertyName((Method)method))});
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBeanByName.class.getSimpleName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Unable to assign the Spring bean value to method annotated with @" + SpringBeanByName.class.getSimpleName() + ". Method " + "has thrown an exception.", e.getCause());
            }
        }
    }

    protected boolean isDatabaseModuleEnabled() {
        return Unitils.getInstance().getModulesRepository().isModuleEnabled(DatabaseModule.class);
    }

    protected DatabaseModule getDatabaseModule() {
        return (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
    }

    public TestListener getTestListener() {
        return new SpringTestListener();
    }

    protected class SpringTestListener
    extends TestListener {
        protected SpringTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            SpringModule.this.injectApplicationContext(testObject);
            SpringModule.this.injectSpringBeans(testObject);
            SpringModule.this.injectSpringBeansByType(testObject);
            SpringModule.this.injectSpringBeansByName(testObject);
        }
    }
}

