/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.jpa.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.database.DatabaseModule;
import org.unitils.orm.common.util.ConfiguredOrmPersistenceUnit;
import org.unitils.orm.common.util.OrmPersistenceUnitLoader;
import org.unitils.orm.jpa.JpaModule;
import org.unitils.orm.jpa.util.JpaConfig;
import org.unitils.orm.jpa.util.JpaProviderSupport;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaEntityManagerFactoryLoader
implements OrmPersistenceUnitLoader<EntityManagerFactory, Object, JpaConfig> {
    protected String databaseName;

    public JpaEntityManagerFactoryLoader(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public ConfiguredOrmPersistenceUnit<EntityManagerFactory, Object> getConfiguredOrmPersistenceUnit(Object testObject, JpaConfig entityManagerConfig) {
        AbstractEntityManagerFactoryBean factoryBean = this.createEntityManagerFactoryBean(testObject, entityManagerConfig);
        EntityManagerFactory entityManagerFactory = factoryBean.getObject();
        Object providerSpecificConfigurationObject = this.getJpaProviderSupport().getProviderSpecificConfigurationObject(factoryBean.getPersistenceProvider());
        return new ConfiguredOrmPersistenceUnit<EntityManagerFactory, Object>(entityManagerFactory, providerSpecificConfigurationObject);
    }

    protected AbstractEntityManagerFactoryBean createEntityManagerFactoryBean(Object testObject, JpaConfig jpaConfig) {
        LocalContainerEntityManagerFactoryBean factoryBean = new LocalContainerEntityManagerFactoryBean();
        factoryBean.setDataSource(this.getDataSource());
        factoryBean.setJpaVendorAdapter(this.getJpaProviderSupport().getSpringJpaVendorAdaptor());
        String persistenceXmlFile = jpaConfig.getConfigFiles().iterator().next();
        if (!StringUtils.isEmpty((String)persistenceXmlFile)) {
            factoryBean.setPersistenceXmlLocation(persistenceXmlFile);
        }
        factoryBean.setPersistenceUnitName(jpaConfig.getPersistenceUnitName());
        LoadTimeWeaver loadTimeWeaver = this.getJpaProviderSupport().getLoadTimeWeaver();
        if (loadTimeWeaver != null) {
            factoryBean.setLoadTimeWeaver(loadTimeWeaver);
        }
        if (jpaConfig.getConfigMethod() != null) {
            try {
                ReflectionUtils.invokeMethod((Object)testObject, (Method)jpaConfig.getConfigMethod(), (Object[])new Object[]{factoryBean});
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Error while invoking custom config method", e.getCause());
            }
        }
        factoryBean.afterPropertiesSet();
        return factoryBean;
    }

    protected DataSource getDataSource() {
        return this.getDatabaseModule().getWrapper(this.databaseName).getDataSource();
    }

    protected JpaProviderSupport getJpaProviderSupport() {
        return this.getJpaModule().getJpaProviderSupport();
    }

    protected DatabaseModule getDatabaseModule() {
        return (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
    }

    protected JpaModule getJpaModule() {
        return (JpaModule)Unitils.getInstance().getModulesRepository().getModuleOfType(JpaModule.class);
    }
}

