/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.ResourceConfigLoader;
import org.unitils.database.DataSourceWrapper;
import org.unitils.database.DatabaseModule;
import org.unitils.database.util.Flushable;
import org.unitils.orm.common.spring.OrmSpringSupport;
import org.unitils.orm.common.util.ConfiguredOrmPersistenceUnit;
import org.unitils.orm.common.util.OrmConfig;
import org.unitils.orm.common.util.OrmPersistenceUnitLoader;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public abstract class OrmModule<ORM_PERSISTENCE_UNIT, ORM_PERSISTENCE_CONTEXT, PROVIDER_CONFIGURATION_OBJECT, PERSISTENCE_UNIT_CONFIG_ANNOTATION extends Annotation, ORM_CONFIG extends OrmConfig, ORM_PERSISTENCE_UNIT_CONFIG_LOADER extends ResourceConfigLoader<ORM_CONFIG>>
implements Module,
Flushable {
    protected ORM_PERSISTENCE_UNIT_CONFIG_LOADER persistenceUnitConfigLoader;
    protected OrmPersistenceUnitLoader<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT, ORM_CONFIG> ormPersistenceUnitLoader;
    protected Map<ORM_CONFIG, ConfiguredOrmPersistenceUnit<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT>> configuredOrmPersistenceUnitCache = new HashMap<ORM_CONFIG, ConfiguredOrmPersistenceUnit<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT>>();
    protected OrmSpringSupport<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT> ormSpringSupport;
    protected String databaseName;
    protected Set<DataSourceWrapper> wrappers = new HashSet<DataSourceWrapper>();

    public void init(Properties configuration) {
        this.persistenceUnitConfigLoader = this.createOrmConfigLoader();
        this.ormPersistenceUnitLoader = this.createOrmPersistenceUnitLoader();
    }

    public void afterInit() {
        this.initOrmSpringSupport();
    }

    protected abstract ORM_PERSISTENCE_UNIT_CONFIG_LOADER createOrmConfigLoader();

    protected abstract Class<PERSISTENCE_UNIT_CONFIG_ANNOTATION> getPersistenceUnitConfigAnnotationClass();

    protected abstract Class<ORM_PERSISTENCE_UNIT> getPersistenceUnitClass();

    protected abstract OrmPersistenceUnitLoader<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT, ORM_CONFIG> createOrmPersistenceUnitLoader();

    protected abstract String getOrmSpringSupportImplClassName();

    public ORM_PERSISTENCE_UNIT getPersistenceUnit(Object testObject) {
        ConfiguredOrmPersistenceUnit<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT> configuredPersistenceUnit = this.getConfiguredPersistenceUnit(testObject);
        return configuredPersistenceUnit.getOrmPersistenceUnit();
    }

    public PROVIDER_CONFIGURATION_OBJECT getConfigurationObject(Object testObject) {
        ConfiguredOrmPersistenceUnit<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT> configuredPersistenceUnit = this.getConfiguredPersistenceUnit(testObject);
        return configuredPersistenceUnit.getOrmConfigurationObject();
    }

    protected ConfiguredOrmPersistenceUnit<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT> getConfiguredPersistenceUnit(Object testObject) {
        if (this.ormSpringSupport != null && this.ormSpringSupport.isPersistenceUnitConfiguredInSpring(testObject)) {
            return this.ormSpringSupport.getConfiguredPersistenceUnit(testObject);
        }
        ORM_CONFIG persistenceUnitConfig = this.getPersistenceUnitConfig(testObject);
        if (persistenceUnitConfig == null) {
            throw new UnitilsException("Could not find a configuring @" + this.getPersistenceUnitConfigAnnotationClass().getSimpleName() + " annotation or custom config method");
        }
        ConfiguredOrmPersistenceUnit<ORM_PERSISTENCE_UNIT, PROVIDER_CONFIGURATION_OBJECT> configuredPersistenceUnit = this.configuredOrmPersistenceUnitCache.get(persistenceUnitConfig);
        if (configuredPersistenceUnit == null) {
            configuredPersistenceUnit = this.ormPersistenceUnitLoader.getConfiguredOrmPersistenceUnit(testObject, persistenceUnitConfig);
            this.configuredOrmPersistenceUnitCache.put(persistenceUnitConfig, configuredPersistenceUnit);
        }
        return configuredPersistenceUnit;
    }

    protected ORM_CONFIG getPersistenceUnitConfig(Object testObject) {
        return (ORM_CONFIG)((OrmConfig)this.persistenceUnitConfigLoader.loadResourceConfig(testObject));
    }

    public boolean isPersistenceUnitConfiguredFor(Object testObject) {
        return this.ormSpringSupport != null && this.ormSpringSupport.isPersistenceUnitConfiguredInSpring(testObject) || this.getPersistenceUnitConfig(testObject) != null;
    }

    public ORM_PERSISTENCE_CONTEXT getPersistenceContext(Object testObject) {
        if (!this.isPersistenceUnitConfiguredFor(testObject)) {
            throw new UnitilsException("No persistence unit has been configured for this test class. Make sure you either configure one in the spring ApplicationContext for this class, or by using the annotation @" + this.getPersistenceUnitConfigAnnotationClass().getSimpleName());
        }
        return this.doGetPersistenceContext(testObject);
    }

    protected abstract ORM_PERSISTENCE_CONTEXT doGetPersistenceContext(Object var1);

    protected ORM_PERSISTENCE_CONTEXT getActivePersistenceContext(Object testObject) {
        if (!this.isPersistenceUnitConfiguredFor(testObject)) {
            return null;
        }
        return this.doGetActivePersistenceContext(testObject);
    }

    protected abstract ORM_PERSISTENCE_CONTEXT doGetActivePersistenceContext(Object var1);

    public void flushDatabaseUpdates(Object testObject) {
        ORM_PERSISTENCE_CONTEXT activePersistenceContext = this.getActivePersistenceContext(testObject);
        if (activePersistenceContext != null) {
            this.flushOrmPersistenceContext(activePersistenceContext);
        }
    }

    protected abstract void flushOrmPersistenceContext(ORM_PERSISTENCE_CONTEXT var1);

    public void injectOrmPersistenceUnitIntoTestObject(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), this.getPersistenceUnitConfigAnnotationClass());
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), this.getPersistenceUnitConfigAnnotationClass());
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            Class<?>[] parameterTypes = ((Method)iterator.next()).getParameterTypes();
            if (parameterTypes.length != 0 && this.getPersistenceUnitClass().isAssignableFrom(parameterTypes[0])) continue;
            iterator.remove();
        }
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        ORM_PERSISTENCE_UNIT persistenceUnit = this.getPersistenceUnit(testObject);
        ReflectionUtils.setFieldAndSetterValue((Object)testObject, (Set)fields, (Set)methods, persistenceUnit);
    }

    protected abstract void getDatabaseName(Object var1, Method var2);

    protected void initOrmSpringSupport() {
        if (!this.isSpringModuleEnabled()) {
            return;
        }
        this.ormSpringSupport = (OrmSpringSupport)ReflectionUtils.createInstanceOfType((String)this.getOrmSpringSupportImplClassName(), (boolean)false);
    }

    protected boolean isSpringModuleEnabled() {
        return Unitils.getInstance().getModulesRepository().isModuleEnabled("org.unitils.spring.SpringModule");
    }

    protected DatabaseModule getDatabaseModule() {
        return (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
    }

    protected class OrmTestListener
    extends TestListener {
        protected OrmTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            OrmModule.this.injectOrmPersistenceUnitIntoTestObject(testObject);
        }
    }
}

