/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.ResourceConfig;
import org.unitils.core.util.ResourceConfigLoader;
import org.unitils.orm.jpa.annotation.JpaEntityManagerFactory;
import org.unitils.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationConfigLoader<A extends Annotation, CFG extends ResourceConfig>
implements ResourceConfigLoader<CFG> {
    protected Class<A> annotationClass;

    public AnnotationConfigLoader(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public CFG loadResourceConfig(Object testObject) {
        return this.getResourceConfig(testObject.getClass());
    }

    protected CFG getResourceConfig(Class<?> testClass) {
        HashSet<A> configuringAnnotations = new HashSet<A>();
        A annotation = testClass.getAnnotation(this.annotationClass);
        if (annotation != null && this.isConfiguringAnnotation(annotation)) {
            configuringAnnotations.add(annotation);
        }
        Set annotatedFields = AnnotationUtils.getFieldsAnnotatedWith(testClass, this.annotationClass);
        for (Field field : annotatedFields) {
            annotation = field.getAnnotation(this.annotationClass);
            if (!this.isConfiguringAnnotation(annotation)) continue;
            configuringAnnotations.add(annotation);
        }
        Set annotatedMethods = AnnotationUtils.getMethodsAnnotatedWith(testClass, this.annotationClass, (boolean)false);
        for (Method annotatedMethod : annotatedMethods) {
            annotation = annotatedMethod.getAnnotation(this.annotationClass);
            if (!this.isConfiguringAnnotation(annotation)) continue;
            configuringAnnotations.add(annotation);
        }
        Method customConfigMethod = null;
        for (Method annotatedMethod : annotatedMethods) {
            if (!this.isCustomConfigMethod(annotatedMethod)) continue;
            customConfigMethod = annotatedMethod;
        }
        if (configuringAnnotations.size() > 1) {
            throw new UnitilsException("Class " + testClass.getSimpleName() + " has " + configuringAnnotations.size() + " configuring @" + this.annotationClass.getSimpleName() + " annotations. There can only be one such annotation per class.");
        }
        if (configuringAnnotations.size() == 0 && customConfigMethod == null) {
            if (Object.class.equals(testClass.getSuperclass())) {
                return null;
            }
            return this.getResourceConfig(testClass.getSuperclass());
        }
        return this.createResourceConfig((Annotation)configuringAnnotations.iterator().next(), customConfigMethod);
    }

    protected abstract CFG createResourceConfig(A var1, Method var2);

    protected Method getCustomConfigMethod(Class<?> testClass) {
        Set annotatedMethods = AnnotationUtils.getMethodsAnnotatedWith(testClass, JpaEntityManagerFactory.class);
        for (Method annotatedMethod : annotatedMethods) {
            if (!this.isCustomConfigMethod(annotatedMethod)) continue;
            return annotatedMethod;
        }
        return null;
    }

    protected abstract boolean isCustomConfigMethod(Method var1);

    protected abstract boolean isConfiguringAnnotation(A var1);
}

