/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.hibernate.util;

import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.database.DatabaseModule;
import org.unitils.orm.common.util.ConfiguredOrmPersistenceUnit;
import org.unitils.orm.common.util.OrmConfig;
import org.unitils.orm.common.util.OrmPersistenceUnitLoader;
import org.unitils.orm.hibernate.HibernateModule;
import org.unitils.orm.hibernate.util.UnitilsLocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionFactoryLoader
implements OrmPersistenceUnitLoader<SessionFactory, Configuration, OrmConfig> {
    @Override
    public ConfiguredOrmPersistenceUnit<SessionFactory, Configuration> getConfiguredOrmPersistenceUnit(Object testObject, OrmConfig entityManagerConfig) {
        LocalSessionFactoryBean factoryBean = this.createSessionFactoryBean(testObject, entityManagerConfig);
        SessionFactory entityManagerFactory = (SessionFactory)factoryBean.getObject();
        Configuration hibernateConfiguration = factoryBean.getConfiguration();
        return new ConfiguredOrmPersistenceUnit<SessionFactory, Configuration>(entityManagerFactory, hibernateConfiguration);
    }

    protected LocalSessionFactoryBean createSessionFactoryBean(Object testObject, OrmConfig entityManagerConfig) {
        UnitilsLocalSessionFactoryBean factoryBean = new UnitilsLocalSessionFactoryBean();
        factoryBean.setDataSource(this.getDataSource());
        factoryBean.setConfigurationClass(this.getConfigurationObjectClass());
        Resource[] hibernateConfigFiles = new Resource[entityManagerConfig.getConfigFiles().size()];
        int index = 0;
        for (String configFileName : entityManagerConfig.getConfigFiles()) {
            hibernateConfigFiles[index++] = new ClassPathResource(configFileName);
        }
        factoryBean.setConfigLocations(hibernateConfigFiles);
        factoryBean.setTestObject(testObject);
        factoryBean.setCustomConfigMethod(entityManagerConfig.getConfigMethod());
        try {
            factoryBean.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new UnitilsException("Error while processing " + LocalSessionFactoryBean.class.getSimpleName() + " configuration", (Throwable)e);
        }
        return factoryBean;
    }

    protected Class<? extends Configuration> getConfigurationObjectClass() {
        return this.getHibernateModule().getConfigurationObjectClass();
    }

    protected DataSource getDataSource() {
        return this.getDatabaseModule().getDataSourceAndActivateTransactionIfNeeded();
    }

    protected DatabaseModule getDatabaseModule() {
        return (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
    }

    protected HibernateModule getHibernateModule() {
        return (HibernateModule)Unitils.getInstance().getModulesRepository().getModuleOfType(HibernateModule.class);
    }
}

