/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock;

import org.unitils.mock.argumentmatcher.ArgumentMatcher;
import org.unitils.mock.argumentmatcher.ArgumentMatcherRepository;
import org.unitils.mock.argumentmatcher.impl.AnyArgumentMatcher;
import org.unitils.mock.argumentmatcher.impl.EqualsArgumentMatcher;
import org.unitils.mock.argumentmatcher.impl.LenEqArgumentMatcher;
import org.unitils.mock.argumentmatcher.impl.NotNullArgumentMatcher;
import org.unitils.mock.argumentmatcher.impl.NullArgumentMatcher;
import org.unitils.mock.argumentmatcher.impl.RefEqArgumentMatcher;
import org.unitils.mock.argumentmatcher.impl.SameArgumentMatcher;
import org.unitils.mock.core.proxy.StackTraceUtils;

public class ArgumentMatchers {
    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T notNull(Class<T> argumentClass) {
        ArgumentMatchers.registerArgumentMatcher(new NotNullArgumentMatcher());
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T isNull(Class<T> argumentClass) {
        ArgumentMatchers.registerArgumentMatcher(new NullArgumentMatcher());
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T same(T sameAs) {
        ArgumentMatchers.registerArgumentMatcher(new SameArgumentMatcher(sameAs));
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T eq(T equalTo) {
        ArgumentMatchers.registerArgumentMatcher(new EqualsArgumentMatcher(equalTo));
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T refEq(T equalTo) {
        ArgumentMatchers.registerArgumentMatcher(new RefEqArgumentMatcher(equalTo));
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T lenEq(T equalTo) {
        ArgumentMatchers.registerArgumentMatcher(new LenEqArgumentMatcher(equalTo));
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static <T> T any(Class<T> type) {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(type));
        return null;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static boolean anyBoolean() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Boolean.class));
        return false;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static byte anyByte() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Byte.class));
        return 0;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static short anyShort() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Short.class));
        return 0;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static char anyChar() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Character.class));
        return '\u0000';
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static int anyInt() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Integer.class));
        return 0;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static long anyLong() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Long.class));
        return 0L;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static float anyFloat() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Float.class));
        return 0.0f;
    }

    @org.unitils.mock.annotation.ArgumentMatcher
    public static double anyDouble() {
        ArgumentMatchers.registerArgumentMatcher(new AnyArgumentMatcher(Double.class));
        return 0.0;
    }

    protected static <T> void registerArgumentMatcher(ArgumentMatcher argumentMatcher) {
        ArgumentMatcherRepository argumentMatcherRepository = ArgumentMatcherRepository.getInstance();
        argumentMatcherRepository.registerArgumentMatcher(argumentMatcher, StackTraceUtils.getInvocationLineNr(ArgumentMatchers.class));
    }
}

