/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.io.annotation.handler;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.io.annotation.TempFile;
import org.unitils.io.temp.TempService;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class TempFileAnnotationHandler
extends TestListener {
    protected Boolean cleanupAfterTest;
    protected TempService tempService;

    public TempFileAnnotationHandler(TempService tempService, boolean cleanupAfterTest) {
        this.tempService = tempService;
        this.cleanupAfterTest = cleanupAfterTest;
    }

    public void beforeTestSetUp(Object testObject, Method testMethod) {
        Set tmpFileFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TempFile.class);
        for (Field field : tmpFileFields) {
            this.createTempFileForField(testObject, testMethod, field);
        }
    }

    public void afterTestMethod(Object testObject, Method testMethod, Throwable t) {
        if (!this.cleanupAfterTest.booleanValue()) {
            return;
        }
        Set tmpFileFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TempFile.class);
        for (Field field : tmpFileFields) {
            this.deleteTempFileForField(testObject, field);
        }
    }

    protected void createTempFileForField(Object testObject, Method testMethod, Field field) {
        TempFile annotation = field.getAnnotation(TempFile.class);
        String fileName = annotation.value();
        if (fileName.isEmpty()) {
            fileName = testObject.getClass().getName() + "-" + testMethod.getName() + ".tmp";
        }
        try {
            File tempFile = this.tempService.createTempFile(fileName);
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)tempFile);
        }
        catch (Exception e) {
            throw new UnitilsException("Error creating temp file for field " + field.getName(), (Throwable)e);
        }
    }

    protected void deleteTempFileForField(Object testObject, Field field) {
        try {
            File tempFile = (File)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            this.tempService.deleteTempFileOrDir(tempFile);
        }
        catch (Exception e) {
            throw new UnitilsException("Error deleting temp file for field " + field.getName(), (Throwable)e);
        }
    }
}

