/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.util.List;
import org.dbunit.dataset.IDataSet;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.dbunit.dataset.Column;
import org.unitils.dbunit.dataset.Row;
import org.unitils.dbunit.dataset.Schema;
import org.unitils.dbunit.dataset.SchemaFactory;
import org.unitils.dbunit.dataset.Table;
import org.unitils.dbunit.dataset.comparison.ColumnDifference;
import org.unitils.dbunit.dataset.comparison.RowDifference;
import org.unitils.dbunit.dataset.comparison.SchemaDifference;
import org.unitils.dbunit.dataset.comparison.TableDifference;

public class DataSetAssert {
    private ObjectFormatter objectFormatter = new ObjectFormatter();

    public void assertEqualSchemas(Schema expectedSchema, Schema actualSchema) throws AssertionError {
        SchemaDifference schemaDifference = expectedSchema.compare(actualSchema);
        if (schemaDifference != null) {
            String message = this.generateErrorMessage(schemaDifference);
            throw new AssertionError((Object)message);
        }
    }

    public void assertEqualDbUnitDataSets(String schemaName, IDataSet expectedDataSet, IDataSet actualDataSet) {
        SchemaFactory dbUnitDataSetBuilder = new SchemaFactory();
        Schema expectedSchema = dbUnitDataSetBuilder.createSchemaForDbUnitDataSet(schemaName, expectedDataSet);
        List<String> expectedTableNames = expectedSchema.getTableNames();
        Schema actualSchema = dbUnitDataSetBuilder.createSchemaForDbUnitDataSet(schemaName, actualDataSet, expectedTableNames);
        this.assertEqualSchemas(expectedSchema, actualSchema);
    }

    protected String generateErrorMessage(SchemaDifference schemaDifference) {
        StringBuilder result = new StringBuilder("Assertion failed. Differences found between the expected data set and actual database content.");
        String schemaName = schemaDifference.getSchema().getName();
        this.appendMissingTableDifferences(schemaDifference, result);
        this.appendTableDifferences(schemaDifference, result);
        result.append("\n\nActual database content:\n\n");
        this.appendSchemaContent(schemaDifference.getSchema(), schemaDifference.getActualSchema(), result);
        return result.toString();
    }

    protected void appendMissingTableDifferences(SchemaDifference schemaDifference, StringBuilder result) {
        for (Table missingTable : schemaDifference.getMissingTables()) {
            result.append("\nFound missing table ");
            result.append(schemaDifference.getSchema().getName());
            result.append(".");
            result.append(missingTable.getName());
        }
    }

    protected void appendTableDifferences(SchemaDifference schemaDifference, StringBuilder result) {
        for (TableDifference tableDifference : schemaDifference.getTableDifferences()) {
            Table table = tableDifference.getTable();
            if (table.isEmpty()) {
                result.append("\nExpected table to be empty but found rows for table ");
                this.appendTableName(schemaDifference.getSchema(), table, result);
                result.append("\n");
                continue;
            }
            result.append("\nFound differences for table ");
            this.appendTableName(schemaDifference.getSchema(), table, result);
            result.append(":\n");
            this.appendMissingRowDifferences(tableDifference, result);
            this.appendBestRowDifferences(tableDifference, result);
        }
    }

    protected void appendMissingRowDifferences(TableDifference tableDifference, StringBuilder result) {
        for (Row missingRow : tableDifference.getMissingRows()) {
            result.append("\n  Missing row:\n  ");
            this.appendColumnNames(missingRow, result);
            result.append("\n  ");
            this.appendRow(missingRow, result);
            result.append("\n");
        }
    }

    protected void appendBestRowDifferences(TableDifference tableDifference, StringBuilder result) {
        for (RowDifference rowDifference : tableDifference.getBestRowDifferences()) {
            result.append("\n  Different row: \n  ");
            this.appendColumnNames(rowDifference.getRow(), result);
            result.append("\n  ");
            this.appendRow(rowDifference.getRow(), result);
            result.append("\n\n  Best matching differences:  ");
            for (Column column : rowDifference.getMissingColumns()) {
                result.append("\n  Missing column ");
                result.append(column.getName());
            }
            for (ColumnDifference columnDifference : rowDifference.getColumnDifferences()) {
                result.append("\n  ");
                result.append(columnDifference.getColumn().getName());
                result.append(": ");
                result.append(this.objectFormatter.format(columnDifference.getColumn().getValue()));
                result.append(" <-> ");
                Column actualColumn = columnDifference.getActualColumn();
                result.append(this.objectFormatter.format(actualColumn == null ? null : actualColumn.getValue()));
            }
            result.append("\n");
        }
    }

    protected void appendColumnNames(Row row, StringBuilder result) {
        for (Column column : row.getColumns()) {
            result.append(column.getName());
            result.append(", ");
        }
        result.setLength(result.length() - 2);
    }

    protected void appendRow(Row row, StringBuilder result) {
        for (Column column : row.getColumns()) {
            result.append(this.objectFormatter.format(column.getValue()));
            result.append(", ");
        }
        result.setLength(result.length() - 2);
    }

    protected void appendSchemaContent(Schema schema, Schema actualSchema, StringBuilder result) {
        for (Table table : schema.getTables()) {
            Table actualTable = actualSchema.getTable(table.getName());
            if (actualTable == null) continue;
            this.appendTableName(schema, actualTable, result);
            result.append("\n");
            if (actualTable.getRows().isEmpty()) {
                result.append("  <empty table>\n");
            } else {
                result.append("  ");
                this.appendColumnNames(actualTable.getRows().get(0), result);
                result.append("\n");
                for (Row row : actualTable.getRows()) {
                    result.append("  ");
                    this.appendRow(row, result);
                    result.append("\n");
                }
            }
            result.append("\n");
        }
    }

    protected void appendTableName(Schema schema, Table table, StringBuilder result) {
        result.append(schema.getName());
        result.append(".");
        result.append(table.getName());
    }
}

