/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dbunit.database.AbstractDatabaseConnection;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.unitils.database.DatabaseUnitils;

public class DbUnitDatabaseConnection
extends AbstractDatabaseConnection {
    private DataSource dataSource;
    private String schemaName;
    private Connection currentlyUsedConnection;
    private Connection currentlyUsedNativeConnection;

    public DbUnitDatabaseConnection(DataSource dataSource, String schemaName) {
        this.dataSource = dataSource;
        this.schemaName = schemaName;
    }

    public void close() throws SQLException {
    }

    public String getSchema() {
        return this.schemaName;
    }

    public Connection getConnection() throws SQLException {
        if (this.currentlyUsedConnection == null) {
            this.currentlyUsedConnection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            this.currentlyUsedNativeConnection = this.getNativeConnection(this.currentlyUsedConnection);
        }
        return DatabaseUnitils.getGoodConnection((Connection)this.currentlyUsedNativeConnection, (DataSource)this.dataSource);
    }

    protected Connection getNativeConnection(Connection connection) throws SQLException {
        Connection targetConnection;
        DatabaseMetaData metaData = connection.getMetaData();
        if (metaData != null && (targetConnection = metaData.getConnection()) != null) {
            return targetConnection;
        }
        return connection;
    }

    public void closeJdbcConnection() throws SQLException {
        if (this.currentlyUsedConnection != null) {
            DataSourceUtils.releaseConnection((Connection)this.currentlyUsedConnection, (DataSource)this.dataSource);
            this.currentlyUsedConnection = null;
            this.currentlyUsedNativeConnection = null;
        }
    }
}

